/**
 * www.jcoverage.com
 * Copyright (C)2003 jcoverage ltd.
 *
 * This file is part of jcoverage.
 *
 * jcoverage is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published
 * by the Free Software Foundation; either version 2 of the License,
 * or (at your option) any later version.
 *
 * jcoverage is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with jcoverage; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 *
 */
package com.jcoverage.reporting.html;

import java.io.*;

/**
 *
 */
public class HtmlFormatHelper {

  /**
   * If developers have tabs in their source code, we cannot emit them
   * in HTML, so will convert them to N non-breaking spaces per tab,
   * where N is this constant.
   * <p>
   * It is recommended that developers avoid using tabs for reasons of
   * code portability.
   */
  public static final int TAB_WIDTH=4;

  public static String untabify(String original,int tabwidth) {
    StringBuffer replacement=new StringBuffer();

    for(int i=0;i<tabwidth;i++) {
      replacement.append(" ");
    }

    return replace(original,"\t",replacement.toString());
  }

  public static String replaceCharacterEntities(String original) {
    return replace(replace(replace(replace(original,"&","&amp;"),"<","&lt;"),">","&gt;"),"\"","&quot;");
  }

  static String replace(String original,String toFind,String replaceWith) {
    StringBuffer result=new StringBuffer();
    int position=0;
    int p;
    
    if(original.indexOf(toFind)==-1) {
      return original;
    }

    while((p=original.indexOf(toFind,position))!=-1) {
      result.append(original.substring(position,p));
      result.append(replaceWith);
      position=p+toFind.length();
    }

    if(position<original.length()) {
      result.append(original.substring(position));
    }


    return result.toString();
  }

  /**
   * Since this is HTML, we'll want to encode the incoming file
   * according to the HTML encoding we're using, so this
   * implementation just delegates to {@link #drainReader(java.io.Reader,java.io.PrintWriter)}.
   * <p>
   * For now, use the platform default encoding, but this can change
   * later.
   */
  public static void drainInputStream(InputStream in,PrintWriter writer) throws IOException {
    if (in==null) {
      throw new IOException("InputStream given to drainInputStream() is null");
    }
    drainReader(new InputStreamReader(in),writer);
  }

  public static void drainReader(Reader in,PrintWriter writer) throws IOException {
    if (in==null) {
      throw new IOException("InputStream given to drainReader() is null");
    }
    BufferedReader reader=new BufferedReader(in);
    while(true) {
      String line=reader.readLine();
      if (line==null) {
        break;
      }
      writer.println(line);
    }
  }
  
}
