/**
 * www.jcoverage.com
 * Copyright (C)2003 jcoverage ltd.
 *
 * This file is part of jcoverage.
 *
 * jcoverage is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published
 * by the Free Software Foundation; either version 2 of the License,
 * or (at your option) any later version.
 *
 * jcoverage is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with jcoverage; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 *
 */
package com.jcoverage.reporting.html;

import java.io.*;
import java.util.*;

/**
 *
 */
public abstract class HtmlBlockElement extends HtmlElement {
  
  List writables;

  protected HtmlBlockElement(String tag) {
    super(tag);
  }

  public void add(Writable writable) {
    if (writables==null) {
      writables=new ArrayList();
    }
    writables.add(writable);
  }
  
  protected List getWritables() {
    return writables;
  }

  protected void openBlock(PrintWriter writer) {
    openElement(writer);
    writer.println();
  }

  protected void closeBlock(PrintWriter writer) {
    writer.println();
    closeElement(writer);
    writer.println();
  }

  public void writeTo(PrintWriter writer) {
    openBlock(writer);
    writeWritables(writer);
    closeBlock(writer);
  }

  protected void writeWritables(PrintWriter writer) {
    for(Iterator it=getWritables().iterator();it.hasNext();) {
      ((Writable)it.next()).writeTo(writer);
    }
  }

}
