/**
 * www.jcoverage.com
 * Copyright (C)2003 jcoverage ltd.
 *
 * This file is part of jcoverage.
 *
 * jcoverage is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published
 * by the Free Software Foundation; either version 2 of the License,
 * or (at your option) any later version.
 *
 * jcoverage is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with jcoverage; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 *
 */
package com.jcoverage.reporting.html;

import java.io.PrintWriter;

import com.jcoverage.reporting.Column;
import com.jcoverage.reporting.FormattingContext;
import com.jcoverage.reporting.Line;

/**
 *
 */
public class DefaultColumnRenderer implements ColumnRenderer {
  
  String label;

  public DefaultColumnRenderer(String label) {
    this.label=label;
  }

  public DefaultColumnRenderer() {
  }

  public void renderField(FormattingContext ctx,PrintWriter writer,Column column,Line line,String href) {
    if (getClassId()!=null) {
      writer.println("<td class=\""+getClassId()+"\">");
    } else {
      writer.println("<td>");
    }
    if (href!=null) {
      writer.print("<a href="+href+">");
    }
    writer.print(getValueAsString(line,column));
    if (href!=null) {
      writer.print("</a>");
    }
    writer.println("</td>");
  }

  public String getValueAsString(Line line,Column column) {
    return line.getField(column).toString();
  }

  public void renderTitle(FormattingContext ctx,PrintWriter writer,Column column,boolean remainder) {
    writer.print("<th");
    if (getWidth()!=null) {
      writer.print(" width=\""+getWidth()+"\"");
    }
    if (remainder) {
      writer.print(" class=\"remainder\"");
    }
    writer.print(">");
    if (label!=null) {
      writer.print(label);
    } else {
      writer.print(column.getLabel());
    }
    writer.print("</th>");
  }

  public String getWidth() {
    return null;
  }

  public String getClassId() {
    return null;
  }
  
}
