/**
 * www.jcoverage.com
 * Copyright (C)2003 jcoverage ltd.
 *
 * This file is part of jcoverage.
 *
 * jcoverage is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published
 * by the Free Software Foundation; either version 2 of the License,
 * or (at your option) any later version.
 *
 * jcoverage is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with jcoverage; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 *
 */
package com.jcoverage.reporting;

import java.io.PrintStream;
import java.io.PrintWriter;

/**
 * A nestable exception supporting exception chaining.
 */
public class ReportingException extends Exception {

  private Throwable cause;
    
  /**
   * Create the exception with just a message. Only use this
   * constructor if there is no cause that can be attributed.
   */
  public ReportingException(String s) {
    super(s);
  }
    
  /**
   * Create the exception with a message and cause.
   */
  public ReportingException(String s,Throwable cause) {
    super(s);
    this.cause = cause;
  }

  public void printStackTrace() { 
    super.printStackTrace();
    if (cause!=null) {
      System.err.println("Caused by: ");
      cause.printStackTrace();
    }
  }

  public void printStackTrace(PrintStream out) { 
    super.printStackTrace(out);
    if (cause!=null) {
      out.println("Caused by: ");
      cause.printStackTrace(out);
    }
  }
  
  public void printStackTrace(PrintWriter out) { 
    super.printStackTrace(out);
    if (cause!=null) {
      out.println("Caused by: ");
      cause.printStackTrace(out);
    }
  }

  public String getMessage() {
    StringBuffer sb=new StringBuffer(super.getMessage());
    if (cause!=null) {
      sb.append("\nCaused by:\n");
      sb.append(cause.toString());
    }
    return sb.toString();
  }
}
