/**
 * www.jcoverage.com
 * Copyright (C)2003 jcoverage ltd.
 *
 * This file is part of jcoverage.
 *
 * jcoverage is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published
 * by the Free Software Foundation; either version 2 of the License,
 * or (at your option) any later version.
 *
 * jcoverage is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with jcoverage; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 *
 */
package com.jcoverage.reporting;

/**
 * Instances of this class represent an information type.
 * Like a database column, it has a name and a type.
 * <p>
 * A field's value can be defined to be any Java object, an int, double or boolean.
 */
public class Column {
  
  String label,classid,description;
  Class type;

  public Column(String label,Class type) {
    this(label,"",type);
  }

  public Column(String label,String description,Class type) {
    if (Object.class.isAssignableFrom(type) || type.equals(Integer.TYPE) || type.equals(Boolean.TYPE) || type.equals(Double.TYPE)) {
      this.label=label;
      this.description=description;
      this.type=type;
    } else {
      throw new IllegalArgumentException("Attribute type cannot be "+type);
    }
  }

  public boolean isAcceptableValue(Object value) {
    if (type.equals(Integer.TYPE) && value.getClass().equals(Integer.class)) {
      return true;
    }
    if (type.equals(Double.TYPE) && value.getClass().equals(Double.class)) {
      return true;
    }
    if (type.equals(Boolean.TYPE) && value.getClass().equals(Boolean.class)) {
      return true;
    }
    return this.type.isAssignableFrom(value.getClass());
  }

  public Object getType() {
    return type;
  }

  public String getLabel() {
    return label;
  }

  public String getDescription() {
    return description;
  }

  public String toString() {
    return "[" + getLabel() + "]";
  }

}
