/**
 * www.jcoverage.com
 * Copyright (C)2003 jcoverage ltd.
 *
 * This file is part of jcoverage.
 *
 * jcoverage is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published
 * by the Free Software Foundation; either version 2 of the License,
 * or (at your option) any later version.
 *
 * jcoverage is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with jcoverage; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 *
 */
package com.jcoverage.reporting;

/**
 * An object that collects pages and sends them to format object for
 * formatting.  Since a collator knows about all the pages, it can
 * provide formats with information based on the overall report
 * structure, such as file organization. Formats get access to a
 * collator through a {@link FormattingContext}.
 */
public interface Collator {
  
  /**
   * This method is called evertime a page is closed and ready to be
   * rendered.
   */
  void pageClosed(Page page) throws ReportingException;

  String getPathToPage(FormattingContext ctx,Page page);

  String getPathToPage(FormattingContext ctx,Page page,Page from);

  String getPathToResource(FormattingContext ctx,String resource,Page from);

  /**
   * Cause the pages to be output using the given format and serializer.
   */
  void addOutputter(Format format,Serializer serializer);

}
