/**
 * www.jcoverage.com
 * Copyright (C)2003 jcoverage ltd.
 *
 * This file is part of jcoverage.
 *
 * jcoverage is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published
 * by the Free Software Foundation; either version 2 of the License,
 * or (at your option) any later version.
 *
 * jcoverage is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with jcoverage; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 *
 */
package com.jcoverage.coverage.reporting.html;

import java.util.Set;

import com.jcoverage.coverage.reporting.collation.ReportSummaryPackageLine;
import com.jcoverage.reporting.Column;
import com.jcoverage.reporting.FormattingContext;
import com.jcoverage.reporting.Page;
import com.jcoverage.reporting.html.ColumnRenderer;
import com.jcoverage.reporting.html.CssColumnRenderer;
import com.jcoverage.reporting.html.RedGreenIndicator;
import com.jcoverage.reporting.html.ReportTable;

/**
 *
 */
public class PackagesTable extends ReportTable {
  
  static Column[] COLUMNS=new Column[]{ReportSummaryPackageLine.COLUMN_PACKAGE_NAME,
                                       ReportSummaryPackageLine.COLUMN_TOTAL_JAVAFILES,
                                       ReportSummaryPackageLine.COLUMN_TOTAL_LINES,
                                       ReportSummaryPackageLine.COLUMN_AVERAGE_COVERAGE_PERCENT,
                                       ReportSummaryPackageLine.COLUMN_AVERAGE_COVERAGE_PERCENT,
                                       ReportSummaryPackageLine.COLUMN_BRANCH_AVERAGE_COVERAGE_PERCENT,
                                       ReportSummaryPackageLine.COLUMN_BRANCH_AVERAGE_COVERAGE_PERCENT};

  public PackagesTable(Page page,Set records,FormattingContext ctx) {
    super(page,records,COLUMNS,ctx);
    setColumnRenderer(ReportSummaryPackageLine.COLUMN_PACKAGE_NAME,new CssColumnRenderer("packagename"));
    setColumnRenderer(ReportSummaryPackageLine.COLUMN_TOTAL_JAVAFILES,new CssColumnRenderer("files"));
    setColumnRenderer(ReportSummaryPackageLine.COLUMN_TOTAL_LINES,new CssColumnRenderer("lines"));
    setColumnRenderer(ReportSummaryPackageLine.COLUMN_AVERAGE_COVERAGE_PERCENT,new PercentColumnRenderer("coverage"));
    setColumnRenderer(ReportSummaryPackageLine.COLUMN_AVERAGE_COVERAGE_PERCENT,new RedGreenIndicator("indicator"),4);
    setColumnRenderer(ReportSummaryPackageLine.COLUMN_BRANCH_AVERAGE_COVERAGE_PERCENT,new PercentColumnRenderer("coverage"));
    setColumnRenderer(ReportSummaryPackageLine.COLUMN_BRANCH_AVERAGE_COVERAGE_PERCENT,new RedGreenIndicator("indicator"),6);
  }
  
}
