/**
 * www.jcoverage.com
 * Copyright (C)2003 jcoverage ltd.
 *
 * This file is part of jcoverage.
 *
 * jcoverage is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published
 * by the Free Software Foundation; either version 2 of the License,
 * or (at your option) any later version.
 *
 * jcoverage is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with jcoverage; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 *
 */
package com.jcoverage.coverage.reporting.html;

import java.util.Set;

import com.jcoverage.coverage.reporting.collation.OverallSummaryLine;
import com.jcoverage.reporting.Column;
import com.jcoverage.reporting.FormattingContext;
import com.jcoverage.reporting.Page;
import com.jcoverage.reporting.html.ColumnRenderer;
import com.jcoverage.reporting.html.LabelColumnRenderer;
import com.jcoverage.reporting.html.CssColumnRenderer;
import com.jcoverage.reporting.html.PercentageRedGreenIndicator;
import com.jcoverage.reporting.html.RedGreenIndicator;
import com.jcoverage.reporting.html.ReportTable;

/**
 *
 */
public class OverallSummaryTable extends ReportTable {
  
  static Column TITLE_COLUMN=new Column(null,String.class);

  static Column[] COLUMNS=new Column[]{TITLE_COLUMN,
                                       OverallSummaryLine.COLUMN_TOTAL_JAVAFILES,
                                       OverallSummaryLine.COLUMN_TOTAL_LINES,
                                       OverallSummaryLine.COLUMN_AVERAGE_COVERAGE_PERCENT,
                                       OverallSummaryLine.COLUMN_AVERAGE_COVERAGE_PERCENT,
                                       OverallSummaryLine.COLUMN_BRANCH_AVERAGE_COVERAGE_PERCENT,
                                       OverallSummaryLine.COLUMN_BRANCH_AVERAGE_COVERAGE_PERCENT};

  public OverallSummaryTable(Page page,Set records,FormattingContext ctx) {
    super(page,records,COLUMNS,ctx);
    setColumnRenderer(TITLE_COLUMN,new LabelColumnRenderer("Overall","Overall coverage figures"));
    setColumnRenderer(OverallSummaryLine.COLUMN_TOTAL_LINES,new CssColumnRenderer("lines"));
    setColumnRenderer(OverallSummaryLine.COLUMN_TOTAL_JAVAFILES,new CssColumnRenderer("files"));
    setColumnRenderer(OverallSummaryLine.COLUMN_AVERAGE_COVERAGE_PERCENT,new PercentColumnRenderer("coverage"));
    setColumnRenderer(OverallSummaryLine.COLUMN_AVERAGE_COVERAGE_PERCENT,new RedGreenIndicator("indicator"),4);
    setColumnRenderer(OverallSummaryLine.COLUMN_BRANCH_AVERAGE_COVERAGE_PERCENT,new PercentColumnRenderer("coverage"));
    setColumnRenderer(OverallSummaryLine.COLUMN_BRANCH_AVERAGE_COVERAGE_PERCENT,new RedGreenIndicator("indicator"),6);
  }

}
