/**
 * www.jcoverage.com
 * Copyright (C)2003 jcoverage ltd.
 *
 * This file is part of jcoverage.
 *
 * jcoverage is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published
 * by the Free Software Foundation; either version 2 of the License,
 * or (at your option) any later version.
 *
 * jcoverage is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with jcoverage; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 *
 */
package com.jcoverage.coverage.reporting.html;

import java.io.PrintWriter;

import com.jcoverage.reporting.FormattingContext;
import com.jcoverage.reporting.Page;
import com.jcoverage.reporting.html.Writable;

/**
 *
 */
public class NavigationBar implements Writable {
  
  StringBuffer buffer=new StringBuffer();

  public NavigationBar(FormattingContext ctx,Page page) {
    buffer=new StringBuffer(page.getLabel().toLowerCase());

    Page refpage=page;
    
    while (refpage.getMasterLine()!=null && refpage.getMasterLine().getOwner()!=null) {
      refpage=refpage.getMasterLine().getOwner();
      buffer.insert(0," | ");
      buffer.insert(0,"<a href=\""+ctx.getCollator().getPathToPage(ctx,refpage,page)+"\">"+refpage.getLabel().toLowerCase()+"</a>");
    }
  }

  public void writeTo(PrintWriter writer) {
    writer.print("<p class=\"navbar\"><b><a href=\"http://jcoverage.com\">jcoverage</a></b> | ");
    writer.println(buffer.toString());
    writer.println("<p>");
  }

}
