/**
 * www.jcoverage.com
 * Copyright (C)2003 jcoverage ltd.
 *
 * This file is part of jcoverage.
 *
 * jcoverage is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published
 * by the Free Software Foundation; either version 2 of the License,
 * or (at your option) any later version.
 *
 * jcoverage is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with jcoverage; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 *
 */
package com.jcoverage.coverage.reporting.html;

import java.io.*;
import java.util.*;

import com.jcoverage.coverage.reporting.collation.JavaFileLine;
import com.jcoverage.coverage.reporting.collation.JavaFilePage;
import com.jcoverage.coverage.reporting.collation.PackageSummaryPage;
import com.jcoverage.reporting.FormattingContext;
import com.jcoverage.reporting.Page;
import com.jcoverage.reporting.ReportingException;
import com.jcoverage.reporting.ViewFormattingContext;
import com.jcoverage.reporting.html.*;
import com.jcoverage.reporting.html.AbstractHtmlFormat;
import com.jcoverage.reporting.html.HtmlFormatHelper;

/**
 *
 */
public class JavaFilePageFormat extends CommonFormat {
  
  public void formatPage(ViewFormattingContext ctx,Page abstractPage) throws ReportingException {
    throw new IllegalStateException(getClass().getName()+" formatPage method does not handle views");
  }

  public void formatPage(FormattingContext ctx,Page abstractPage) throws ReportingException {

    JavaFilePage page=(JavaFilePage)abstractPage;
    JavaFileLine masterLine=page.getJavaFileLine();

    String name=(String)page.getMasterLine().getField(JavaFileLine.COLUMN_FILE_NAME);

    Html html=new Html();
    html.setTitle("jcoverage details for "+name);
    buildHeader(html);

    NavigationBar navbar=new NavigationBar(ctx,page);
    html.add(navbar);

    html.add(new H1("Coverage details for "+name));
    html.add(new SourceTable(masterLine.getSourceFile(),page));

    html.add("<p>");
    html.add(navbar);
    buildFooter(html);
    html.writeTo(getWriter(ctx,page));
  }
  
}
