/**
 * www.jcoverage.com
 * Copyright (C)2003 jcoverage ltd.
 *
 * This file is part of jcoverage.
 *
 * jcoverage is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published
 * by the Free Software Foundation; either version 2 of the License,
 * or (at your option) any later version.
 *
 * jcoverage is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with jcoverage; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 *
 */
package com.jcoverage.coverage.reporting.html;

import java.util.Comparator;
import java.util.Set;
import java.util.TreeSet;

import com.jcoverage.coverage.reporting.collation.JavaFileLine;
import com.jcoverage.coverage.reporting.collation.PackageSummaryPage;
import com.jcoverage.coverage.reporting.collation.ReportSummaryPackageLine;
import com.jcoverage.coverage.reporting.collation.ReportSummaryPage;
import com.jcoverage.reporting.Column;
import com.jcoverage.reporting.Line;
import com.jcoverage.reporting.LineCategory;
import com.jcoverage.reporting.Page;
import com.jcoverage.reporting.staticgen.StaticView;

/**
 *
 */
public class CoverageView implements StaticView {
  
  public final static int ASCENDING=1;
  public final static int DESCENDING=-1;

  Comparator packageComparator,fileComparator;
  String label;
  int direction;

  class CoverageComparator implements Comparator {

    Column column;
    int direction;

    CoverageComparator(Column column,int direction) {
      this.column=column;
      this.direction=direction;
    }

    public int compare(Object o1,Object o2) {
      if (o1 instanceof Line && o2 instanceof Line) {

        double cov1=((Double)((Line)o1).getField(column)).doubleValue();
        double cov2=((Double)((Line)o2).getField(column)).doubleValue();

        if (o1.equals(o2)) {
          return 0;
        } else if (cov1<cov2) {
          return direction;
        } else {
          return -direction;
        }
      } else {
        throw new ClassCastException("Arguments must both be of type "+Line.class.getName());
      }
    }
  }

  public CoverageView(String label,int direction) {
    this.label=label;
    this.direction=direction;
    this.packageComparator=new CoverageComparator(ReportSummaryPackageLine.COLUMN_AVERAGE_COVERAGE,direction);
    this.fileComparator=new CoverageComparator(JavaFileLine.COLUMN_COVERAGE,direction);
  }

  public Set orderLines(Set lines,LineCategory category) {
    if (category.equals(ReportSummaryPage.CATEGORY_PACKAGE_SUMMARY)) {
      Set set=new TreeSet(packageComparator);
      set.addAll(lines);
      return set;
    } else if (category.equals(PackageSummaryPage.CATEGORY_JAVAFILES)) {
      Set set=new TreeSet(fileComparator);
      set.addAll(lines);
      return set;
    } else {
      throw new IllegalArgumentException("Illegal category "+category);
    }
  }

  public String getFilenameModifier(Page page) {
    if (page.getClass().equals(ReportSummaryPage.class) || page.getClass().equals(PackageSummaryPage.class)) {
      switch(direction) {
      case ASCENDING: return "cova";
      default: return "covd";
      }
    } else {
      return null;
    }
  }

  public String getLabel() {
    return label;
  }

}
