/**
 * www.jcoverage.com
 * Copyright (C)2003 jcoverage ltd.
 *
 * This file is part of jcoverage.
 *
 * jcoverage is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published
 * by the Free Software Foundation; either version 2 of the License,
 * or (at your option) any later version.
 *
 * jcoverage is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with jcoverage; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 *
 */
package com.jcoverage.coverage.reporting.html;

import java.text.Collator;
import java.util.Comparator;
import java.util.Set;
import java.util.TreeSet;

import com.jcoverage.coverage.reporting.collation.JavaFileLine;
import com.jcoverage.coverage.reporting.collation.PackageSummaryPage;
import com.jcoverage.coverage.reporting.collation.ReportSummaryPackageLine;
import com.jcoverage.coverage.reporting.collation.ReportSummaryPage;
import com.jcoverage.reporting.Column;
import com.jcoverage.reporting.Line;
import com.jcoverage.reporting.LineCategory;
import com.jcoverage.reporting.Page;
import com.jcoverage.reporting.View;
import com.jcoverage.reporting.staticgen.StaticView;

/**
 *
 */
public class AlphabeticalView implements StaticView {
  
  Comparator packageComparator=new AlphabeticalComparator(ReportSummaryPackageLine.COLUMN_PACKAGE_NAME);
  Comparator filenameComparator=new AlphabeticalComparator(JavaFileLine.COLUMN_FILE_NAME);

  String label,id;

  class AlphabeticalComparator implements Comparator {

    Column column;
    Comparator delegate=Collator.getInstance();

    AlphabeticalComparator(Column column) {
      this.column=column;
    }

    public int compare(Object o1,Object o2) {
      if (o1 instanceof Line && o2 instanceof Line) {
        String s1=(String)((Line)o1).getField(column);
        String s2=(String)((Line)o2).getField(column);
        return delegate.compare(s1,s2);
      } else {
        throw new ClassCastException("Arguments must both be of type "+Line.class.getName());
      }
    }
  }

  public AlphabeticalView(String label) {
    this.label=label;
  }

  public Set orderLines(Set lines,LineCategory category) {
    if (category.equals(ReportSummaryPage.CATEGORY_PACKAGE_SUMMARY)) {
      Set set=new TreeSet(packageComparator);
      set.addAll(lines);
      return set;
    } else if (category.equals(PackageSummaryPage.CATEGORY_JAVAFILES)) {
      Set set=new TreeSet(filenameComparator);
      set.addAll(lines);
      return set;
    } else {
      throw new IllegalArgumentException("Illegal category "+category);
    }
  }

  public String getFilenameModifier(Page page) {
    if (page.getClass().equals(ReportSummaryPage.class)) {
      return "alpha";
    } else if (page.getClass().equals(PackageSummaryPage.class)) {
      return "alpha";
    } else {
      return null;
    }
  }

  public String getLabel() {
    return label;
  }

}
