/**
 * Copyright (C)2004 dGIC Corporation.
 *
 * This file is part of djUnit plugin.
 *
 * djUnit plugin is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published
 * by the Free Software Foundation; either version 2 of the License,
 * or (at your option) any later version.
 *
 * djUnit plugin is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with djUnit plugin; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 *
 */
package jp.co.dgic.testing.common;

import java.io.File;
import java.io.IOException;

import jp.co.dgic.testing.common.virtualmock.BcelAdviceImplementer;

import org.apache.bcel.Repository;
import org.apache.bcel.classfile.JavaClass;

import com.jcoverage.coverage.BcelCoverageInstrumenter;


public class BcelClassModifier implements IClassModifier {

	private AbstractBcelModifier modifier;

	public BcelClassModifier() {
		// use BCEL
		modifier = new BcelCoverageInstrumenter();
		AbstractBcelModifier bcelAdviceInplementer = new BcelAdviceImplementer();

		modifier.setNext(bcelAdviceInplementer);
	}

	public byte[] getModifiedClass(String className) throws Exception {

		if (isTestCase(className)) {
			return null;
		}

		return modifier.getModifiedByteCode(Repository.lookupClass(className));
	}

	public byte[] modifyClass(String className) throws Exception {
		return modifier.getModifiedByteCode(Repository.lookupClass(className));
	}

	private boolean isTestCase(String className) throws ClassNotFoundException {
		JavaClass testCase = Repository.lookupClass("junit.framework.TestCase");
		JavaClass jc = Repository.lookupClass(className);

		if (jc.instanceOf(testCase)) return true;
		
		BcelJUnit4AnnotationReader reader = new BcelJUnit4AnnotationReader(jc);
		return reader.hasJUnit4Annotation();
	}
	
	public void writeFile(String className) throws IOException, ClassNotFoundException {
		JavaClass jc = Repository.lookupClass(className);
		jc.dump(className);
	}

	public void writeFile(String className, String directoryName) throws IOException, ClassNotFoundException {
		JavaClass jc = Repository.lookupClass(className);
		jc.dump(new File(directoryName + "/" + className + ".class"));
	}

}
