/**
 * Copyright (C)2004 dGIC Corporation.
 *
 * This file is part of djUnit plugin.
 *
 * djUnit plugin is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published
 * by the Free Software Foundation; either version 2 of the License,
 * or (at your option) any later version.
 *
 * djUnit plugin is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with djUnit plugin; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 *
 */
package jp.co.dgic.eclipse.jdt.internal.coverage.report;

import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;

public class FieldLabel extends CLabel implements ICoverageLabel {

	private static final RGB RGB_BACKGROUND = new RGB(255, 255, 255);
	private static final RGB RGB_LINE_BACKGROUND = new RGB(240, 240, 240);
	private static final RGB RGB_CONTENTS = new RGB(72, 0, 170);

	public FieldLabel(Composite parent, int style) {
		super(parent, style);
		setFont(new Font(getDisplay(), new FontData("Courier New", 10, SWT.NORMAL)));
		setBackground(new Color(getDisplay(), RGB_LINE_BACKGROUND));
		setForeground(new Color(getDisplay(), RGB_CONTENTS));
	}

	public void setLineNumber(int lineNumber) {
		if ((lineNumber % 2) == 0) {
			setBackground(new Color(getDisplay(), RGB_LINE_BACKGROUND));
		} else {
			setBackground(new Color(getDisplay(), RGB_BACKGROUND));
		}
	}

	public Point computeSize(int wHint, int hHint, boolean changed) {
		return getSize();
	}

	protected void checkSubclass() {
	}

}
