/*
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 2000-2002 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution, if
 *    any, must include the following acknowlegement:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowlegement may appear in the software itself,
 *    if and wherever such third-party acknowlegements normally appear.
 *
 * 4. The names "Ant" and "Apache Software
 *    Foundation" must not be used to endorse or promote products derived
 *    from this software without prior written permission. For written
 *    permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache"
 *    nor may "Apache" appear in their names without prior written
 *    permission of the Apache Group.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */
package jp.co.dgic.djunit.ant;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.URLClassLoader;

public class DJUnitRunner {

	private static final String TEST_RUNNER_CLASSNAME = "org.apache.tools.ant.taskdefs.optional.junit.JUnitTestRunner";

	public static void main(String[] args) throws Exception {

		checkAndCreateClassloader();

		URLClassLoader loader = (URLClassLoader) Thread.currentThread().getContextClassLoader();
		Class clas = loader.loadClass(TEST_RUNNER_CLASSNAME);

		// invoke "main" method of target class
		Method main = clas.getDeclaredMethod("main", new Class[] { args.getClass() });
		Thread.currentThread().setContextClassLoader(loader);
		main.invoke(null, new Object[] { args });

	}

	private static void checkAndCreateClassloader() {
		URLClassLoader loader = (URLClassLoader) Thread.currentThread().getContextClassLoader();
		if (!loader.getClass().getName().equalsIgnoreCase(DJUnitJvmArgs.DJUNIT_CLASS_LOADER)) {
			try {
				Class cls = loader.loadClass(DJUnitJvmArgs.DJUNIT_CLASS_LOADER);
				Constructor c = cls.getConstructor(new Class[] {ClassLoader.class});
				Object newLoader = c.newInstance(new Object[] {loader});
				Thread.currentThread().setContextClassLoader((ClassLoader) newLoader);
			} catch (Throwable t) {
				t.printStackTrace();
				System.exit(-1);
			}
		}
	}

}
