/*
 * Decompiled with CFR 0.152.
 */
package com.jcoverage.tool.coveragecheck;

import com.jcoverage.coverage.Instrumentation;
import com.jcoverage.coverage.InstrumentationPersistence;
import com.jcoverage.tool.coveragecheck.CoverageRate;
import gnu.getopt.Getopt;
import gnu.getopt.LongOpt;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;

public class Main
extends InstrumentationPersistence {
    final Perl5Matcher pm = new Perl5Matcher();
    final Perl5Compiler pc = new Perl5Compiler();
    Map minimumCoverageRates = new HashMap();
    CoverageRate minimumCoverageRate;
    File instrumentationDirectory = new File(System.getProperty("user.dir"));

    void setInstrumentationDirectory(File instrumentationDirectory) {
        this.instrumentationDirectory = instrumentationDirectory;
    }

    double inRangeAndDivideByOneHundred(String coverageRateAsPercentage) {
        return this.inRangeAndDivideByOneHundred(Integer.valueOf(coverageRateAsPercentage));
    }

    double inRangeAndDivideByOneHundred(int coverageRateAsPercentage) {
        if (coverageRateAsPercentage >= 0 && coverageRateAsPercentage <= 100) {
            return (double)coverageRateAsPercentage / 100.0;
        }
        throw new IllegalArgumentException("Invalid value, valid range is [0 .. 100]");
    }

    void setMinimumCoverageRate(String minimumCoverageRate) throws MalformedPatternException {
        StringTokenizer tokenizer = new StringTokenizer(minimumCoverageRate, ":");
        this.minimumCoverageRates.put(this.pc.compile(tokenizer.nextToken()), new CoverageRate(this.inRangeAndDivideByOneHundred(tokenizer.nextToken()), this.inRangeAndDivideByOneHundred(tokenizer.nextToken())));
    }

    CoverageRate findMinimumCoverageRate(String key) {
        Iterator i = this.minimumCoverageRates.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            if (!this.pm.matches(key, (Pattern)entry.getKey())) continue;
            return (CoverageRate)entry.getValue();
        }
        return this.minimumCoverageRate;
    }

    Main(String[] args) throws IOException, MalformedPatternException {
        int c;
        System.out.println("jcoverage @product.version@ copyright (c)2003 jcoverage ltd. http://jcoverage.com/");
        System.out.println("jcoverage is licensed under the GNU General Public License");
        System.out.println("jcoverage comes with ABSOLUTELY NO WARRANTY");
        System.out.println("jcoverage check");
        LongOpt[] longOpts = new LongOpt[]{new LongOpt("branch", 1, null, 98), new LongOpt("line", 1, null, 108), new LongOpt("directory", 1, null, 100), new LongOpt("regex", 1, null, 114)};
        Getopt g = new Getopt(this.getClass().getName(), args, ":b:l:d:r:", longOpts);
        double branchCoverageRate = 0.8;
        double lineCoverageRate = 0.7;
        while ((c = g.getopt()) != -1) {
            switch (c) {
                case 98: {
                    branchCoverageRate = this.inRangeAndDivideByOneHundred(g.getOptarg());
                    break;
                }
                case 108: {
                    lineCoverageRate = this.inRangeAndDivideByOneHundred(g.getOptarg());
                    break;
                }
                case 100: {
                    this.setInstrumentationDirectory(new File(g.getOptarg()));
                    break;
                }
                case 114: {
                    this.setMinimumCoverageRate(g.getOptarg());
                }
            }
        }
        this.minimumCoverageRate = new CoverageRate(lineCoverageRate, branchCoverageRate);
        this.merge(this.loadInstrumentation(new FileInputStream(new File(this.instrumentationDirectory, "jcoverage.ser"))));
        Iterator i = this.keySet().iterator();
        while (i.hasNext()) {
            StringBuffer sb;
            String key = (String)i.next();
            CoverageRate coverageRate = this.findMinimumCoverageRate(key);
            Instrumentation instrumentation = this.getInstrumentation(key);
            if (instrumentation.getLineCoverageRate() < coverageRate.getLineCoverageRate()) {
                sb = new StringBuffer();
                sb.append(key);
                sb.append(" line coverage rate of: ");
                sb.append(this.percentage(instrumentation.getLineCoverageRate()));
                sb.append("% (required: ");
                sb.append(this.percentage(coverageRate.getLineCoverageRate()));
                sb.append("%)");
                System.out.println(sb.toString());
            }
            if (!(instrumentation.getBranchCoverageRate() < coverageRate.getBranchCoverageRate())) continue;
            sb = new StringBuffer();
            sb.append(key);
            sb.append(" branch coverage rate of: ");
            sb.append(this.percentage(instrumentation.getBranchCoverageRate()));
            sb.append("% (required: ");
            sb.append(this.percentage(coverageRate.getBranchCoverageRate()));
            sb.append("%)");
            System.out.println(sb.toString());
        }
    }

    String percentage(double coverateRate) {
        BigDecimal decimal = new BigDecimal(coverateRate * 100.0);
        return decimal.setScale(1, 1).toString();
    }

    public static void main(String[] args) throws IOException, MalformedPatternException {
        new Main(args);
    }
}

