/*
 * Decompiled with CFR 0.152.
 */
package com.jcoverage.reporting.html;

import com.jcoverage.reporting.Column;
import com.jcoverage.reporting.FormattingContext;
import com.jcoverage.reporting.Line;
import com.jcoverage.reporting.html.ColumnRenderer;
import java.io.PrintWriter;

public class DefaultColumnRenderer
implements ColumnRenderer {
    String label;

    public DefaultColumnRenderer(String label) {
        this.label = label;
    }

    public DefaultColumnRenderer() {
    }

    public void renderField(FormattingContext ctx, PrintWriter writer, Column column, Line line, String href) {
        if (this.getClassId() != null) {
            writer.println("<td class=\"" + this.getClassId() + "\">");
        } else {
            writer.println("<td>");
        }
        if (href != null) {
            writer.print("<a href=" + href + ">");
        }
        writer.print(this.getValueAsString(line, column));
        if (href != null) {
            writer.print("</a>");
        }
        writer.println("</td>");
    }

    public String getValueAsString(Line line, Column column) {
        return line.getField(column).toString();
    }

    public void renderTitle(FormattingContext ctx, PrintWriter writer, Column column, boolean remainder) {
        writer.print("<th");
        if (this.getWidth() != null) {
            writer.print(" width=\"" + this.getWidth() + "\"");
        }
        if (remainder) {
            writer.print(" class=\"remainder\"");
        }
        writer.print(">");
        if (this.label != null) {
            writer.print(this.label);
        } else {
            writer.print(column.getLabel());
        }
        writer.print("</th>");
    }

    public String getWidth() {
        return null;
    }

    public String getClassId() {
        return null;
    }
}

