/*
 * Decompiled with CFR 0.152.
 */
package com.jcoverage.coverage.reporting.collation;

import com.jcoverage.coverage.reporting.collation.JavaFileLine;
import com.jcoverage.coverage.reporting.collation.JavaFilePage;
import com.jcoverage.coverage.reporting.collation.PackageSummaryPage;
import com.jcoverage.coverage.reporting.collation.ReportSummaryPackageLine;
import com.jcoverage.coverage.reporting.collation.ReportSummaryPage;
import com.jcoverage.coverage.reporting.html.MultiViewStaticHtmlFormat;
import com.jcoverage.reporting.AbstractCollator;
import com.jcoverage.reporting.FormattingContext;
import com.jcoverage.reporting.MultiViewCollator;
import com.jcoverage.reporting.Page;
import com.jcoverage.reporting.View;
import com.jcoverage.reporting.ViewFormattingContext;
import com.jcoverage.reporting.staticgen.StaticView;

public class StaticFileCollator
extends AbstractCollator
implements MultiViewCollator {
    String suffix;

    public StaticFileCollator(String suffix) {
        this.suffix = suffix.startsWith(".") ? suffix : "." + suffix;
    }

    String getFilenameModifier(View view, Page page) {
        String result = "";
        if (view != null) {
            if (view instanceof StaticView) {
                String modifier;
                if (!view.equals(MultiViewStaticHtmlFormat.ALPHABETICAL_VIEW) && (modifier = ((StaticView)view).getFilenameModifier(page)) != null) {
                    result = String.valueOf(modifier) + "/";
                }
            } else {
                throw new IllegalStateException("Views given to this StaticFileCollator must be of type StaticView, this one is " + view.getClass());
            }
        }
        return result;
    }

    String getUniquePathFromComponents(View view, Page page, String name, String suffix) {
        return String.valueOf(this.getFilenameModifier(view, page)) + name + suffix;
    }

    String getPathToPageView(View view, Page page) {
        if (page instanceof ReportSummaryPage) {
            return this.getUniquePathFromComponents(view, page, "index", this.suffix);
        }
        if (page instanceof PackageSummaryPage) {
            String packageName = (String)page.getMasterLine().getField(ReportSummaryPackageLine.COLUMN_PACKAGE_NAME);
            return this.getUniquePathFromComponents(view, page, packageName, this.suffix);
        }
        if (page instanceof JavaFilePage) {
            String clzName = (String)page.getMasterLine().getField(JavaFileLine.COLUMN_FILE_NAME);
            return this.getUniquePathFromComponents(view, page, clzName, this.suffix);
        }
        return null;
    }

    public String getPathToPage(FormattingContext ctx, Page page) {
        if (ctx instanceof ViewFormattingContext) {
            return this.getPathToPageView(((ViewFormattingContext)ctx).getCurrentView(), page);
        }
        return this.getPathToPageView(null, page);
    }

    public String getPathToPage(FormattingContext ctx, Page page, Page from) {
        return AbstractCollator.getRelativePath(this.getPathToPage(ctx, from), this.getPathToPage(ctx, page));
    }

    public String getPathToResource(FormattingContext ctx, String resource, Page from) {
        return AbstractCollator.getRelativePath(this.getPathToPage(ctx, from), resource);
    }

    public String getPathToPage(ViewFormattingContext ctx, Page page, Page from, View toView) {
        return AbstractCollator.getRelativePath(this.getPathToPage(ctx, from), this.getPathToPageView(toView, page));
    }
}

