/*
 * Decompiled with CFR 0.152.
 */
package com.jcoverage.coverage.reporting.collation;

import com.jcoverage.coverage.reporting.collation.FieldHelper;
import com.jcoverage.coverage.reporting.collation.ReportSummaryPackageLine;
import com.jcoverage.coverage.reporting.collation.ReportSummaryPage;
import com.jcoverage.reporting.AbstractLine;
import com.jcoverage.reporting.Column;
import com.jcoverage.reporting.Line;
import com.jcoverage.reporting.Page;
import java.util.Iterator;

public class OverallSummaryLine
extends AbstractLine
implements Line {
    public static Column COLUMN_TOTAL_JAVAFILES;
    public static Column COLUMN_TOTAL_LINES;
    public static Column COLUMN_AVERAGE_COVERAGE;
    public static Column COLUMN_AVERAGE_COVERAGE_PERCENT;
    public static Column COLUMN_BRANCH_AVERAGE_COVERAGE;
    public static Column COLUMN_BRANCH_AVERAGE_COVERAGE_PERCENT;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.Integer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        COLUMN_TOTAL_JAVAFILES = new Column("files", clazz);
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("java.lang.Integer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        COLUMN_TOTAL_LINES = new Column("lines", clazz2);
        Class<?> clazz3 = class$1;
        if (clazz3 == null) {
            try {
                clazz3 = class$1 = Class.forName("java.lang.Double");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        COLUMN_AVERAGE_COVERAGE = new Column("", clazz3);
        Class<?> clazz4 = class$0;
        if (clazz4 == null) {
            try {
                clazz4 = class$0 = Class.forName("java.lang.Integer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        COLUMN_AVERAGE_COVERAGE_PERCENT = new Column("%line", clazz4);
        Class<?> clazz5 = class$1;
        if (clazz5 == null) {
            try {
                clazz5 = class$1 = Class.forName("java.lang.Double");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        COLUMN_BRANCH_AVERAGE_COVERAGE = new Column("", clazz5);
        Class<?> clazz6 = class$0;
        if (clazz6 == null) {
            try {
                clazz6 = class$0 = Class.forName("java.lang.Integer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        COLUMN_BRANCH_AVERAGE_COVERAGE_PERCENT = new Column("%branch", clazz6);
    }

    public Page instantiateDetailPage() {
        return new ReportSummaryPage();
    }

    public Object getField(Column column) {
        Object o = super.getField(column);
        if (column.equals(COLUMN_TOTAL_LINES)) {
            return new Integer(this.getTotalLines());
        }
        if (column.equals(COLUMN_AVERAGE_COVERAGE)) {
            return new Double(this.getAverageLineCoverageRate());
        }
        if (column.equals(COLUMN_AVERAGE_COVERAGE_PERCENT)) {
            return new Integer(FieldHelper.toPercent(this.getAverageLineCoverageRate()));
        }
        if (column.equals(COLUMN_BRANCH_AVERAGE_COVERAGE)) {
            return new Double(this.getAverageBranchCoverageRate());
        }
        if (column.equals(COLUMN_BRANCH_AVERAGE_COVERAGE_PERCENT)) {
            return new Integer(FieldHelper.toPercent(this.getAverageBranchCoverageRate()));
        }
        if (column.equals(COLUMN_TOTAL_JAVAFILES)) {
            return new Integer(this.getTotalJavaFiles());
        }
        return o;
    }

    double getAverageLineCoverageRate() {
        int totalLines = 0;
        int coveredLines = 0;
        Iterator it = this.getDetailPage().getLines(ReportSummaryPage.CATEGORY_PACKAGE_SUMMARY).iterator();
        while (it.hasNext()) {
            Line line = (Line)it.next();
            int sourceLineCount = (Integer)line.getField(ReportSummaryPackageLine.COLUMN_TOTAL_LINES);
            totalLines += sourceLineCount;
            double rate = (Double)line.getField(ReportSummaryPackageLine.COLUMN_AVERAGE_COVERAGE);
            coveredLines += (int)((double)sourceLineCount * rate);
        }
        if (totalLines == 0) {
            return 1.0;
        }
        return (double)coveredLines / (double)totalLines;
    }

    double getAverageBranchCoverageRate() {
        if (this.getDetailPage().getLines(ReportSummaryPage.CATEGORY_PACKAGE_SUMMARY).size() == 0) {
            return 0.0;
        }
        double total = 0.0;
        Iterator it = this.getDetailPage().getLines(ReportSummaryPage.CATEGORY_PACKAGE_SUMMARY).iterator();
        while (it.hasNext()) {
            Line line = (Line)it.next();
            total += ((Double)line.getField(ReportSummaryPackageLine.COLUMN_BRANCH_AVERAGE_COVERAGE)).doubleValue();
        }
        return total / (double)this.getDetailPage().getLines(ReportSummaryPage.CATEGORY_PACKAGE_SUMMARY).size();
    }

    int getTotalLines() {
        int totalLines = 0;
        Iterator it = this.getDetailPage().getLines(ReportSummaryPage.CATEGORY_PACKAGE_SUMMARY).iterator();
        while (it.hasNext()) {
            Line line = (Line)it.next();
            totalLines += ((Integer)line.getField(ReportSummaryPackageLine.COLUMN_TOTAL_LINES)).intValue();
        }
        return totalLines;
    }

    int getTotalJavaFiles() {
        int totalFiles = 0;
        Iterator it = this.getDetailPage().getLines(ReportSummaryPage.CATEGORY_PACKAGE_SUMMARY).iterator();
        while (it.hasNext()) {
            Line line = (Line)it.next();
            totalFiles += ((Integer)line.getField(ReportSummaryPackageLine.COLUMN_TOTAL_JAVAFILES)).intValue();
        }
        return totalFiles;
    }
}

