/*
 * Decompiled with CFR 0.152.
 */
package com.jcoverage.coverage.reporting.collation;

import com.jcoverage.coverage.Instrumentation;
import com.jcoverage.coverage.reporting.collation.JavaFileLine;
import com.jcoverage.reporting.AbstractPage;
import com.jcoverage.reporting.Line;
import com.jcoverage.reporting.Page;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public class JavaFilePage
extends AbstractPage
implements Page {
    Set instrumentations = new HashSet();
    JavaFileLine masterLine;
    SortedSet coverageUnion = new TreeSet(new Comparator(){

        public int compare(Object o1, Object o2) {
            int i2;
            int i1 = (Integer)((Map.Entry)o1).getKey();
            if (i1 < (i2 = ((Integer)((Map.Entry)o2).getKey()).intValue())) {
                return -1;
            }
            return 1;
        }
    });
    Set validSourceLines = new HashSet();

    public JavaFilePage() {
        super("File");
    }

    public Set getSourceFileLineCoverageSet() {
        return this.coverageUnion;
    }

    public JavaFileLine getJavaFileLine() {
        return this.masterLine;
    }

    public void addInstrumentation(Instrumentation instrumentation) {
        this.instrumentations.add(instrumentation);
        this.coverageUnion.addAll(instrumentation.getCoverage().entrySet());
        this.validSourceLines.addAll(instrumentation.getSourceLineNumbers());
    }

    public void setMasterLine(Line masterLine) {
        super.setMasterLine(masterLine);
        this.masterLine = (JavaFileLine)masterLine;
    }

    public Set getValidSourceLines() {
        return this.validSourceLines;
    }

    public int getSourceLinesCount() {
        int sourceLines = 0;
        Iterator it = this.instrumentations.iterator();
        while (it.hasNext()) {
            sourceLines += ((Instrumentation)it.next()).getSourceLineNumbers().size();
        }
        return sourceLines;
    }

    public double getLineCoverageRate() {
        int sourceLines = this.getSourceLinesCount();
        if (sourceLines == 0) {
            return 0.0;
        }
        return (double)this.coverageUnion.size() / (double)sourceLines;
    }

    public double getBranchCoverageRate() {
        if (this.getLineCoverageRate() == 0.0) {
            return 0.0;
        }
        double total = 0.0;
        Iterator i = this.instrumentations.iterator();
        while (i.hasNext()) {
            total += ((Instrumentation)i.next()).getBranchCoverageRate();
        }
        return total / (double)this.instrumentations.size();
    }
}

