/*
 * Decompiled with CFR 0.152.
 */
package com.jcoverage.coverage.reporting;

import com.jcoverage.coverage.Instrumentation;
import com.jcoverage.coverage.reporting.collation.JavaFileLine;
import com.jcoverage.coverage.reporting.collation.JavaFilePage;
import com.jcoverage.coverage.reporting.collation.PackageSummaryPage;
import com.jcoverage.coverage.reporting.collation.ReportImpl;
import com.jcoverage.coverage.reporting.collation.ReportSummaryPackageLine;
import com.jcoverage.coverage.reporting.collation.ReportSummaryPage;
import com.jcoverage.coverage.reporting.collation.StaticFileCollator;
import com.jcoverage.coverage.reporting.html.MultiViewStaticHtmlFormat;
import com.jcoverage.reporting.FileSerializer;
import com.jcoverage.reporting.Line;
import com.jcoverage.reporting.Page;
import com.jcoverage.reporting.Report;
import com.jcoverage.util.ClassHelper;
import java.io.File;

public class ReportDriver {
    File javaSourceDirectory;
    Report report = new ReportImpl();
    Page indexPage;

    public ReportDriver(File javaSourceDirectory) {
        this.javaSourceDirectory = javaSourceDirectory;
        this.indexPage = this.report.createFrontPage();
    }

    public synchronized void addInstrumentation(String clzName, Instrumentation instrumentation) {
        if (!ReportDriver.isInnerClass(clzName)) {
            String id = ReportDriver.getSourceFileId(clzName, instrumentation);
            String sourcePath = String.valueOf(id.replace('.', '/')) + ".java";
            String packageName = ClassHelper.getPackageName(id);
            if (packageName.equals("")) {
                packageName = "default";
            }
            Line packageLine = this.indexPage.lookupLineByField(ReportSummaryPage.CATEGORY_PACKAGE_SUMMARY, ReportSummaryPackageLine.COLUMN_PACKAGE_NAME, packageName);
            Page packageDetailPage = null;
            if (packageLine == null) {
                packageLine = this.indexPage.createLine(ReportSummaryPage.CATEGORY_PACKAGE_SUMMARY);
                packageLine.setField(ReportSummaryPackageLine.COLUMN_PACKAGE_NAME, packageName);
                packageDetailPage = packageLine.openDetailPage();
            } else {
                packageDetailPage = packageLine.getDetailPage();
            }
            Line javaFileLine = packageDetailPage.lookupLineByField(PackageSummaryPage.CATEGORY_JAVAFILES, JavaFileLine.COLUMN_FILE_NAME, clzName);
            Page javaFileDetailPage = null;
            if (javaFileLine == null) {
                javaFileLine = packageDetailPage.createLine(PackageSummaryPage.CATEGORY_JAVAFILES);
                javaFileLine.setField(JavaFileLine.COLUMN_FILE_NAME, clzName);
                javaFileLine.setField(JavaFileLine.COLUMN_PATH, new File(this.javaSourceDirectory, sourcePath).getAbsolutePath());
                javaFileDetailPage = javaFileLine.openDetailPage();
            } else {
                javaFileDetailPage = javaFileLine.getDetailPage();
            }
            this.indexPage.addLineReference(javaFileLine, PackageSummaryPage.CATEGORY_JAVAFILES);
            ((JavaFilePage)javaFileDetailPage).addInstrumentation(instrumentation);
        }
    }

    public void generate(File outputDir) throws Exception {
        StaticFileCollator collator = new StaticFileCollator(".html");
        this.report.setCollator(collator);
        MultiViewStaticHtmlFormat htmlFormat = new MultiViewStaticHtmlFormat();
        FileSerializer serializer = new FileSerializer(outputDir);
        collator.addOutputter(htmlFormat, serializer);
        this.indexPage.close();
    }

    public static String getSourceFileId(String clzName, Instrumentation instrumentation) {
        if (ReportDriver.isInnerClass(clzName)) {
            throw new IllegalStateException("Cannot call this method (getSourceFileId) for an inner class");
        }
        String pkgname = ClassHelper.getPackageName(clzName);
        if (instrumentation.getSourceFileName() == null) {
            return clzName;
        }
        if (pkgname.equals("")) {
            return ReportDriver.stripJavaSuffix(instrumentation.getSourceFileName());
        }
        return String.valueOf(pkgname) + "." + ReportDriver.stripJavaSuffix(instrumentation.getSourceFileName());
    }

    public static String stripJavaSuffix(String s) {
        return s.substring(0, s.length() - ".java".length());
    }

    public static boolean isInnerClass(String clzName) {
        return clzName.indexOf("$") != -1;
    }
}

