/*
 * Decompiled with CFR 0.152.
 */
package com.jcoverage.coverage;

import com.jcoverage.coverage.InstrumentMethodGen;
import com.jcoverage.util.MethodHelper;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.ClassGen;

class InstrumentClassGen {
    final ClassGen cg;
    final Set sourceLineNumbers = new TreeSet();
    final Set methodNamesAndSignatures = new TreeSet();
    final Map methodLineNumbers = new HashMap();
    final Map methodConditionals = new HashMap();
    final String ignoreRegex;
    static /* synthetic */ Class class$0;

    InstrumentClassGen(JavaClass jc, String ignoreRegex) {
        this.cg = new ClassGen(jc);
        this.ignoreRegex = ignoreRegex;
    }

    private void add(Method method, InstrumentMethodGen instrument) {
        this.methodNamesAndSignatures.add(MethodHelper.getMethodNameAndSignature(method));
        this.methodLineNumbers.put(MethodHelper.getMethodNameAndSignature(method), instrument.getSourceLineNumbers());
        this.methodConditionals.put(MethodHelper.getMethodNameAndSignature(method), instrument.getConditionals());
        this.addSourceLineNumbers(instrument.getSourceLineNumbers());
    }

    void addInstrumentation(Method method) {
        InstrumentMethodGen instrument = new InstrumentMethodGen(method, this.cg, this.ignoreRegex);
        instrument.addInstrumentation();
        this.add(method, instrument);
    }

    void addInstrumentation(Method[] methods) {
        int i = 0;
        while (i < methods.length) {
            this.addInstrumentation(methods[i]);
            ++i;
        }
    }

    void addInstrumentation() {
        this.addInstrumentation(this.getClassGen().getMethods());
        ClassGen classGen = this.getClassGen();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.jcoverage.coverage.HasBeenInstrumented");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classGen.addInterface(clazz.getName());
    }

    ClassGen getClassGen() {
        return this.cg;
    }

    private void addSourceLineNumbers(Set sourceLineNumbers) {
        this.sourceLineNumbers.addAll(sourceLineNumbers);
    }

    Set getSourceLineNumbers() {
        return this.sourceLineNumbers;
    }

    Map getMethodLineNumbers() {
        return this.methodLineNumbers;
    }

    Map getMethodConditionals() {
        return this.methodConditionals;
    }

    Set getMethodNamesAndSignatures() {
        return this.methodNamesAndSignatures;
    }
}

