/*
 * Decompiled with CFR 0.152.
 */
package com.jcoverage.ant;

import com.jcoverage.ant.CommonMatchingTask;
import com.jcoverage.ant.Ignore;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.FileSet;

public class InstrumentTask
extends CommonMatchingTask {
    Ignore ignoreRegex = null;

    public InstrumentTask() {
        super("com.jcoverage.coverage.Instrument");
    }

    public Ignore createIgnore() {
        this.ignoreRegex = new Ignore();
        return this.ignoreRegex;
    }

    void coverage(String[] filenames) {
        if (filenames.length == 0) {
            return;
        }
        int i = 0;
        while (i < filenames.length) {
            this.getProject().log("Adding " + filenames[i] + " to list", 3);
            this.getJava().createArg().setValue(filenames[i]);
            ++i;
        }
        System.out.println("jcoverage @product.version@ copyright (c)2003 jcoverage ltd. http://jcoverage.com/");
        System.out.println("jcoverage is licensed under the GNU General Public License");
        System.out.println("jcoverage comes with ABSOLUTELY NO WARRANTY");
        System.out.println("instrumenting " + filenames.length + " " + (filenames.length == 1 ? "class" : "classes") + (this.toDir != null ? " to " + this.toDir : ""));
        if (this.getJava().executeJava() != 0) {
            throw new BuildException();
        }
    }

    public void execute() throws BuildException {
        if (this.toDir != null) {
            this.getJava().createArg().setValue("-d");
            this.getJava().createArg().setValue(this.toDir.toString());
        }
        if (this.ignoreRegex != null) {
            this.getJava().createArg().setValue("-ignore");
            this.getJava().createArg().setValue(this.ignoreRegex.getRegex());
        }
        HashSet<String> filenames = new HashSet<String>();
        Iterator i = this.fileSets.iterator();
        while (i.hasNext()) {
            FileSet fileSet = (FileSet)i.next();
            this.getJava().createArg().setValue("-basedir");
            this.getJava().createArg().setValue(this.baseDir(fileSet));
            filenames.addAll(Arrays.asList(this.getFilenames(fileSet)));
        }
        this.coverage(filenames.toArray(new String[filenames.size()]));
    }
}

