/*
 * Decompiled with CFR 0.152.
 */
package com.jcoverage.ant;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.LinkedList;
import java.util.List;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Java;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;
import org.apache.tools.ant.util.FileNameMapper;
import org.apache.tools.ant.util.IdentityMapper;
import org.apache.tools.ant.util.SourceFileScanner;

public abstract class CommonMatchingTask
extends MatchingTask {
    final String className;
    final List fileSets = new LinkedList();
    private Java java = null;
    File toDir = null;

    public CommonMatchingTask(String className) {
        this.className = className;
    }

    private String getClassName() {
        return this.className;
    }

    protected Java getJava() {
        if (this.java == null) {
            this.java = (Java)this.getProject().createTask("java");
            this.java.setTaskName(this.getTaskName());
            this.java.setClassname(this.getClassName());
            this.java.setFork(true);
            this.java.setDir(this.getProject().getBaseDir());
            if (((Object)((Object)this)).getClass().getClassLoader() instanceof AntClassLoader) {
                this.createClasspath().setPath(((AntClassLoader)((Object)((Object)this)).getClass().getClassLoader()).getClasspath());
            } else if (((Object)((Object)this)).getClass().getClassLoader() instanceof URLClassLoader) {
                URL[] earls = ((URLClassLoader)((Object)((Object)this)).getClass().getClassLoader()).getURLs();
                int i = 0;
                while (i < earls.length) {
                    this.createClasspath().setPath(earls[i].getFile());
                    ++i;
                }
            }
        }
        return this.java;
    }

    public void setTodir(File toDir) {
        this.toDir = toDir;
    }

    public Path createClasspath() {
        return this.getJava().createClasspath().createPath();
    }

    public void setClasspath(Path classpath) {
        this.createClasspath().append(classpath);
    }

    public void setClasspathRef(Reference r) {
        this.createClasspath().setRefid(r);
    }

    DirectoryScanner getDirectoryScanner(FileSet fileSet) {
        return fileSet.getDirectoryScanner(this.getProject());
    }

    String[] getIncludedFiles(FileSet fileSet) {
        return this.getDirectoryScanner(fileSet).getIncludedFiles();
    }

    String[] getExcludedFiles(FileSet fileSet) {
        return this.getDirectoryScanner(fileSet).getExcludedFiles();
    }

    String[] getFilenames(FileSet fileSet) {
        String[] filesToReturn = this.getIncludedFiles(fileSet);
        if (this.toDir != null) {
            IdentityMapper m = new IdentityMapper();
            SourceFileScanner sfs = new SourceFileScanner((Task)this);
            filesToReturn = sfs.restrict(this.getIncludedFiles(fileSet), fileSet.getDir(this.getProject()), this.toDir, (FileNameMapper)m);
        }
        return filesToReturn;
    }

    String baseDir(FileSet fileSet) {
        return fileSet.getDirectoryScanner(this.getProject()).getBasedir().toString();
    }

    public void addFileset(FileSet fileSet) {
        this.fileSets.add(fileSet);
    }
}

