/*
 * Decompiled with CFR 0.152.
 */
package jp.co.dgic.testing.common.virtualmock;

import jp.co.dgic.testing.common.util.DJUnitUtil;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;

public class VirtualMockUtil {
    public static final String VIRTUALMOCK_USE_VIRTUALMOCK_KEY = "jp.co.dgic.eclipse.virtualmock.usevirtualmock";
    public static final String VIRTUALMOCK_INCLUDE_CLASS_KEY = "jp.co.dgic.eclipse.virtualmock.include.class";
    public static final String VIRTUALMOCK_IGNORE_LIBRARY_KEY = "jp.co.dgic.eclipse.virtualmock.ignore.library";
    public static final String VIRTUALMOCK_NOTIGNORE_PATTERNS_KEY = "jp.co.dgic.eclipse.virtualmock.notignore.patterns";

    public static boolean isUseVirtualMock() {
        String useVirtualMock = System.getProperty(VIRTUALMOCK_USE_VIRTUALMOCK_KEY);
        if (useVirtualMock == null) {
            return false;
        }
        return "true".equalsIgnoreCase(useVirtualMock);
    }

    public static boolean isIgnoreLibrary() {
        String isIgnoreLibrary = System.getProperty(VIRTUALMOCK_IGNORE_LIBRARY_KEY);
        if (isIgnoreLibrary == null) {
            return false;
        }
        return "true".equalsIgnoreCase(isIgnoreLibrary);
    }

    public static boolean isNotIgnore(String className) {
        String[] patterns = VirtualMockUtil.getNotIgnorePatterns();
        if (patterns == null) {
            return false;
        }
        Perl5Matcher matcher = new Perl5Matcher();
        Perl5Compiler compiler = new Perl5Compiler();
        int index = 0;
        while (index < patterns.length) {
            try {
                if (matcher.matches(className, compiler.compile(patterns[index]))) {
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++index;
        }
        return false;
    }

    private static String[] getNotIgnorePatterns() {
        String notIgnorePatterns = System.getProperty(VIRTUALMOCK_NOTIGNORE_PATTERNS_KEY);
        if (notIgnorePatterns == null) {
            return null;
        }
        return DJUnitUtil.splitValue(notIgnorePatterns);
    }

    public static String toIncludeValue(String[] fileNames) {
        if (fileNames == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        sb.append("-D");
        sb.append(VIRTUALMOCK_INCLUDE_CLASS_KEY);
        sb.append("=");
        int i = 0;
        while (i < fileNames.length) {
            sb.append(VirtualMockUtil.toClassName(fileNames[i]));
            sb.append(";");
            ++i;
        }
        return sb.toString();
    }

    public static String getIncludeValue() {
        return System.getProperty(VIRTUALMOCK_INCLUDE_CLASS_KEY);
    }

    public static boolean isInclude(String className) {
        String includeValue = VirtualMockUtil.getIncludeValue();
        if (includeValue == null) {
            return true;
        }
        String[] includes = DJUnitUtil.splitValue(includeValue);
        int i = 0;
        while (i < includes.length) {
            if (className.equals(includes[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static String toClassName(String fileName) {
        String className = null;
        if (fileName.endsWith(".class")) {
            int index = fileName.lastIndexOf(46);
            className = fileName.substring(0, index);
        }
        return className.replace('\\', '.');
    }
}

