/*
 * Decompiled with CFR 0.152.
 */
package jp.co.dgic.eclipse.jdt.internal.junit.ui;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Properties;
import jp.co.dgic.eclipse.jdt.internal.junit.ui.DJUnitMessages;
import jp.co.dgic.eclipse.jdt.internal.junit.ui.DJUnitPlugin;
import jp.co.dgic.eclipse.jdt.internal.junit.ui.ExcludePropertyPanel;
import jp.co.dgic.eclipse.jdt.internal.junit.ui.TabFolderLayout;
import jp.co.dgic.testing.common.util.DJUnitUtil;
import org.eclipse.core.internal.resources.Folder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.internal.ui.wizards.TypedElementSelectionValidator;
import org.eclipse.jdt.internal.ui.wizards.TypedViewerFilter;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.FolderSelectionDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.views.navigator.ResourceSorter;

public class DJUnitProjectPropertyPage
extends PropertyPage {
    private static final String JUNIT_DEFAULT_EXCLUDED_PATHS = "";
    private static final String PROPERTIES_FILENAME = ".djunitplugin";
    private static final String USE_COVERAGE_KEY = "UseCoverage";
    private static final String USE_MARKER_KEY = "UseMarker";
    private static final String USE_VIRTUALMOCK_KEY = "UseVirtualMock";
    private static final String COVERAGE_WORK_DIRECTORY_KEY = "CoverageWorkingDirectory";
    private static final String COVERAGE_EXCLUDED_PATTERNS_KEY = "CoverageExcludedPatterns";
    private static final String COVERAGE_INCLUDED_PATTERNS_KEY = "CoverageIncludedPatterns";
    private static final String JUNIT_EXCLUDED_PATHS_KEY = "JUnitExcludedPaths";
    private static final String JUNIT_EXCLUDED_USE_DEFAULT_KEY = "JUnitExcludedUseDefault";
    private static final String VIRTUALMOCK_IGNORE_LIBRARY_KEY = "VirtualMockIgnoreLibrary";
    private static final String VIRTUALMOCK_NOTIGNORE_PATTERNS_KEY = "VirtualMockNotIgnorePatterns";
    private static final String USE_NOVERIFY_KEY = "UseNoverify";
    private static final String BYTECODE_LIBRARY_KEY = "BytecodeLibrary";
    private TabFolder folder;
    private Button useCoverageButton;
    private Button useMarkerButton;
    private Button useVirtualMockButton;
    private Button ignoreLibraryButton;
    private Button useNoverifyButton;
    private Button useAsm;
    private Button useBcel;
    private Text workDirectoryName;
    private ExcludePropertyPanel coverageExcludedProperty;
    private ExcludePropertyPanel coverageIncludedProperty;
    private ExcludePropertyPanel virtualmockNotIgnoreProperty;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    protected Control createContents(Composite parent) {
        this.folder = new TabFolder(parent, 0);
        this.folder.setLayout((Layout)new TabFolderLayout());
        this.folder.setLayoutData((Object)new GridData(1808));
        TabItem coverageTab = new TabItem(this.folder, 0);
        coverageTab.setText(DJUnitMessages.getString("DJUnitProjectPropertyPage.label.coveragetab"));
        coverageTab.setControl((Control)this.createCoveragePanel((Composite)this.folder));
        TabItem virtualMockTab = new TabItem(this.folder, 0);
        virtualMockTab.setText(DJUnitMessages.getString("DJUnitProjectPropertyPage.label.virtualmocktab"));
        virtualMockTab.setControl((Control)this.createVirtualMockPanel((Composite)this.folder));
        TabItem junitTab = new TabItem(this.folder, 0);
        junitTab.setText(DJUnitMessages.getString("DJUnitProjectPropertyPage.label.junittab"));
        junitTab.setControl((Control)this.createJunitPanel((Composite)this.folder));
        return null;
    }

    private Composite createCoveragePanel(Composite parent) {
        Composite c = new Composite(parent, 0);
        GridLayout gl = new GridLayout();
        gl.numColumns = 2;
        c.setLayout((Layout)gl);
        this.useCoverageButton = new Button(c, 32);
        this.useCoverageButton.setText(DJUnitMessages.getString("DJUnitProjectPropertyPage.coverage.label.usecoverage"));
        this.useCoverageButton.setSelection(this.readUseCoverage());
        new Label(c, 0);
        this.useMarkerButton = new Button(c, 32);
        this.useMarkerButton.setText(DJUnitMessages.getString("DJUnitProjectPropertyPage.coverage.label.usemarker"));
        this.useMarkerButton.setSelection(this.readUseMarker());
        new Label(c, 0);
        new Label(c, 0).setText(DJUnitMessages.getString("DJUnitProjectPropertyPage.coverage.label.workingdirectory"));
        new Label(c, 0);
        this.workDirectoryName = new Text(c, 2060);
        GridData gd = new GridData(768);
        gd.widthHint = 300;
        this.workDirectoryName.setLayoutData((Object)gd);
        String workingDirName = this.readWorkingDirectory();
        this.workDirectoryName.setText(workingDirName == null ? JUNIT_DEFAULT_EXCLUDED_PATHS : workingDirName);
        Button workDirectorySelectionButton = new Button(c, 0);
        workDirectorySelectionButton.setText(DJUnitMessages.getString("DJUnitProjectPropertyPage.coverage.label.choicefolder"));
        workDirectorySelectionButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DJUnitProjectPropertyPage.this.openFolderSelectionDialog();
            }
        });
        this.coverageIncludedProperty = new ExcludePropertyPanel(c, 300, 120);
        this.coverageIncludedProperty.setText(DJUnitMessages.getString("DJUnitProjectPropertyPage.coverage.label.includedpatterns"));
        this.coverageIncludedProperty.setValue(this.readCoverageIncludedPatterns());
        new Label(c, 0);
        this.coverageExcludedProperty = new ExcludePropertyPanel(c, 300, 120);
        this.coverageExcludedProperty.setText(DJUnitMessages.getString("DJUnitProjectPropertyPage.coverage.label.excludedpatterns"));
        this.coverageExcludedProperty.setValue(this.readCoverageExcludedPatterns());
        return c;
    }

    private Composite createVirtualMockPanel(Composite parent) {
        Composite c = new Composite(parent, 0);
        GridLayout gl = new GridLayout();
        gl.numColumns = 1;
        c.setLayout((Layout)gl);
        this.useVirtualMockButton = new Button(c, 32);
        this.useVirtualMockButton.setText(DJUnitMessages.getString("DJUnitProjectPropertyPage.virtualmock.label.usevirtualmock"));
        this.useVirtualMockButton.setSelection(this.readUseVirtualMock());
        new Label(c, 0);
        this.ignoreLibraryButton = new Button(c, 32);
        this.ignoreLibraryButton.setText(DJUnitMessages.getString("DJUnitProjectPropertyPage.virtualmock.label.ignorelibrary"));
        this.ignoreLibraryButton.setSelection(this.readIgnoreLibrary());
        this.ignoreLibraryButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean isSelected = ((Button)e.getSource()).getSelection();
                DJUnitProjectPropertyPage.this.virtualmockNotIgnoreProperty.setEnabled(isSelected);
            }
        });
        this.virtualmockNotIgnoreProperty = new ExcludePropertyPanel(c, false);
        this.virtualmockNotIgnoreProperty.setText(DJUnitMessages.getString("DJUnitProjectPropertyPage.virtualmock.label.notignorepatterns"));
        this.virtualmockNotIgnoreProperty.setValue(this.readNotIgnorePatterns());
        this.virtualmockNotIgnoreProperty.setEnabled(this.ignoreLibraryButton.getSelection());
        return c;
    }

    private Composite createJunitPanel(Composite parent) {
        Composite c = new Composite(parent, 0);
        GridLayout gl = new GridLayout();
        gl.numColumns = 1;
        c.setLayout((Layout)gl);
        Group libGroup = new Group(c, 0);
        GridLayout groupLayout = new GridLayout();
        groupLayout.numColumns = 2;
        libGroup.setLayout((Layout)groupLayout);
        libGroup.setText(DJUnitMessages.getString("DJUnitProjectPropertyPage.classloader.label.bytecodelibrary"));
        this.useAsm = new Button((Composite)libGroup, 16);
        this.useAsm.setText("ASM");
        this.useBcel = new Button((Composite)libGroup, 16);
        this.useBcel.setText("BCEL");
        String library = this.readBytecodeLibrary();
        if ("BCEL".equals(library)) {
            this.useBcel.setSelection(true);
        } else {
            this.useAsm.setSelection(true);
        }
        this.useNoverifyButton = new Button(c, 32);
        this.useNoverifyButton.setText(DJUnitMessages.getString("DJUnitProjectPropertyPage.virtualmock.label.noverify"));
        this.useNoverifyButton.setSelection(this.readUseNoverify());
        return c;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void saveProjectSettings() {
        OutputStream out = null;
        try {
            try {
                Properties p = DJUnitProjectPropertyPage.getProperties(this.getJavaProject().getProject());
                p.put(USE_COVERAGE_KEY, new Boolean(this.useCoverageButton.getSelection()).toString());
                p.put(USE_MARKER_KEY, new Boolean(this.useMarkerButton.getSelection()).toString());
                p.put(COVERAGE_WORK_DIRECTORY_KEY, this.workDirectoryName.getText());
                p.put(COVERAGE_EXCLUDED_PATTERNS_KEY, this.coverageExcludedProperty.getValue());
                p.put(COVERAGE_INCLUDED_PATTERNS_KEY, this.coverageIncludedProperty.getValue());
                p.put(USE_VIRTUALMOCK_KEY, new Boolean(this.useVirtualMockButton.getSelection()).toString());
                p.put(VIRTUALMOCK_IGNORE_LIBRARY_KEY, new Boolean(this.ignoreLibraryButton.getSelection()).toString());
                p.put(VIRTUALMOCK_NOTIGNORE_PATTERNS_KEY, this.virtualmockNotIgnoreProperty.getValue());
                p.put(USE_NOVERIFY_KEY, new Boolean(this.useNoverifyButton.getSelection()).toString());
                String library = this.useBcel.getSelection() ? "BCEL" : "ASM";
                p.put(BYTECODE_LIBRARY_KEY, library);
                p.put(COVERAGE_WORK_DIRECTORY_KEY, this.workDirectoryName.getText());
                out = new FileOutputStream(DJUnitProjectPropertyPage.getPropertyFile(this.getJavaProject().getProject()));
                p.store(out, "djUnit Plugin Settings");
            }
            catch (Throwable t) {
                DJUnitPlugin.log(t);
            }
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            try {
                out.flush();
                ((FileOutputStream)out).close();
                throw throwable;
            }
            catch (IOException e) {
                DJUnitPlugin.log(e);
            }
            throw throwable;
        }
        {
            Object var4_7 = null;
        }
        try {}
        catch (IOException e) {
            DJUnitPlugin.log(e);
            return;
        }
        out.flush();
        ((FileOutputStream)out).close();
    }

    private String readWorkingDirectory() {
        String directoryName = null;
        try {
            directoryName = DJUnitProjectPropertyPage.readWorkingDirectory(this.getJavaProject().getProject());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return directoryName;
    }

    private boolean readUseCoverage() {
        boolean useCoverage = true;
        try {
            useCoverage = DJUnitProjectPropertyPage.readUseCoverage(this.getJavaProject().getProject());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return useCoverage;
    }

    private boolean readUseMarker() {
        boolean useMarker = true;
        try {
            useMarker = DJUnitProjectPropertyPage.readUseMarker(this.getJavaProject().getProject());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return useMarker;
    }

    private boolean readUseVirtualMock() {
        boolean useVmo = false;
        try {
            useVmo = DJUnitProjectPropertyPage.readUseVirtualMock(this.getJavaProject().getProject());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return useVmo;
    }

    private boolean readIgnoreLibrary() {
        boolean isIgnoreLibrary = false;
        try {
            isIgnoreLibrary = DJUnitProjectPropertyPage.readIgnoreLibrary(this.getJavaProject().getProject());
        }
        catch (Throwable t) {
            DJUnitPlugin.log(t);
        }
        return isIgnoreLibrary;
    }

    private boolean readUseNoverify() {
        boolean useNoverify = false;
        try {
            useNoverify = DJUnitProjectPropertyPage.readUseNoverify(this.getJavaProject().getProject());
        }
        catch (Throwable t) {
            DJUnitPlugin.log(t);
        }
        return useNoverify;
    }

    private String readBytecodeLibrary() {
        String library = "ASM";
        try {
            library = DJUnitProjectPropertyPage.readBytecodeLibrary(this.getJavaProject().getProject());
        }
        catch (Throwable t) {
            DJUnitPlugin.log(t);
        }
        return library;
    }

    private String readNotIgnorePatterns() {
        String patterns = null;
        try {
            patterns = DJUnitProjectPropertyPage.getProperties(this.getJavaProject().getProject()).getProperty(VIRTUALMOCK_NOTIGNORE_PATTERNS_KEY);
        }
        catch (Throwable t) {
            DJUnitPlugin.log(t);
        }
        return patterns;
    }

    private String readCoverageExcludedPatterns() {
        String patterns = null;
        try {
            patterns = DJUnitProjectPropertyPage.getProperties(this.getJavaProject().getProject()).getProperty(COVERAGE_EXCLUDED_PATTERNS_KEY);
        }
        catch (Throwable t) {
            DJUnitPlugin.log(t);
        }
        return patterns;
    }

    private String readCoverageIncludedPatterns() {
        String patterns = null;
        try {
            patterns = DJUnitProjectPropertyPage.getProperties(this.getJavaProject().getProject()).getProperty(COVERAGE_INCLUDED_PATTERNS_KEY);
        }
        catch (Throwable t) {
            DJUnitPlugin.log(t);
        }
        return patterns;
    }

    public static String readWorkingDirectory(IProject project) {
        String directoeyName = DJUnitProjectPropertyPage.getProperties(project).getProperty(COVERAGE_WORK_DIRECTORY_KEY);
        return directoeyName == null ? JUNIT_DEFAULT_EXCLUDED_PATHS : directoeyName;
    }

    public static boolean readUseCoverage(IProject project) {
        String useCoverage = DJUnitProjectPropertyPage.getProperties(project).getProperty(USE_COVERAGE_KEY);
        return !"false".equalsIgnoreCase(useCoverage);
    }

    public static boolean readUseMarker(IProject project) {
        String useMarker = DJUnitProjectPropertyPage.getProperties(project).getProperty(USE_MARKER_KEY);
        return !"false".equalsIgnoreCase(useMarker);
    }

    public static boolean readUseVirtualMock(IProject project) {
        String useVirtualMock = DJUnitProjectPropertyPage.getProperties(project).getProperty(USE_VIRTUALMOCK_KEY);
        return "true".equalsIgnoreCase(useVirtualMock);
    }

    public static boolean readIgnoreLibrary(IProject project) {
        String ignoreLibrary = DJUnitProjectPropertyPage.getProperties(project).getProperty(VIRTUALMOCK_IGNORE_LIBRARY_KEY);
        return "true".equalsIgnoreCase(ignoreLibrary);
    }

    public static String readNotIgnorePatterns(IProject project) {
        String patterns = DJUnitProjectPropertyPage.getProperties(project).getProperty(VIRTUALMOCK_NOTIGNORE_PATTERNS_KEY);
        return patterns == null ? JUNIT_DEFAULT_EXCLUDED_PATHS : DJUnitProjectPropertyPage.removeInvalidValues(patterns);
    }

    public static boolean readUseNoverify(IProject project) {
        String iseNoverify = DJUnitProjectPropertyPage.getProperties(project).getProperty(USE_NOVERIFY_KEY);
        return "true".equalsIgnoreCase(iseNoverify);
    }

    public static String readBytecodeLibrary(IProject project) {
        String bytecodeLibrary = DJUnitProjectPropertyPage.getProperties(project).getProperty(BYTECODE_LIBRARY_KEY);
        if (bytecodeLibrary == null || JUNIT_DEFAULT_EXCLUDED_PATHS.equals(bytecodeLibrary)) {
            return "ASM";
        }
        return bytecodeLibrary;
    }

    public static String readCoverageExcludedPatterns(IProject project) {
        String patterns = DJUnitProjectPropertyPage.getProperties(project).getProperty(COVERAGE_EXCLUDED_PATTERNS_KEY);
        return patterns == null ? JUNIT_DEFAULT_EXCLUDED_PATHS : DJUnitProjectPropertyPage.removeInvalidValues(patterns);
    }

    public static String readCoverageIncludedPatterns(IProject project) {
        String patterns = DJUnitProjectPropertyPage.getProperties(project).getProperty(COVERAGE_INCLUDED_PATTERNS_KEY);
        return patterns == null ? JUNIT_DEFAULT_EXCLUDED_PATHS : DJUnitProjectPropertyPage.removeInvalidValues(patterns);
    }

    private static String removeInvalidValues(String value) {
        String[] values = DJUnitUtil.splitValue(value);
        if (values == null) {
            return JUNIT_DEFAULT_EXCLUDED_PATHS;
        }
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < values.length) {
            if (!values[i].startsWith("{{INVALID}}")) {
                sb.append(values[i]);
                sb.append(";");
            }
            ++i;
        }
        return sb.toString();
    }

    private String addProjectPathString(String directoryPathString) throws CoreException {
        return String.valueOf(this.getJavaProject().getProject().getName()) + directoryPathString;
    }

    private String removeProjectPathString(String directoryPathString) throws CoreException {
        String projectPath = this.getJavaProject().getProject().getLocation().toString();
        if (directoryPathString.length() <= projectPath.length()) {
            return directoryPathString;
        }
        return directoryPathString.substring(projectPath.length());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Properties getProperties(IProject project) {
        Properties p = new Properties();
        File f = null;
        FileInputStream in = null;
        try {
            try {
                f = DJUnitProjectPropertyPage.getPropertyFile(project);
                if (!f.exists()) {
                    f.createNewFile();
                }
                in = new FileInputStream(f);
                p.load(in);
            }
            catch (Throwable t) {
                DJUnitPlugin.log(t);
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            try {
                in.close();
                throw throwable;
            }
            catch (IOException e) {
                DJUnitPlugin.log(e);
            }
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        try {}
        catch (IOException e) {
            DJUnitPlugin.log(e);
            return p;
        }
        in.close();
        return p;
    }

    private static File getPropertyFile(IProject project) throws CoreException {
        return project.getLocation().append(PROPERTIES_FILENAME).toFile();
    }

    protected IJavaProject getJavaProject() throws CoreException {
        IAdaptable iAdaptable = this.getElement();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.resources.IProject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IProject project = (IProject)iAdaptable.getAdapter((Class)clazz);
        return (IJavaProject)project.getNature("org.eclipse.jdt.core.javanature");
    }

    protected void performApply() {
        this.saveProjectSettings();
    }

    protected void performDefaults() {
        this.useCoverageButton.setSelection(true);
        this.useMarkerButton.setSelection(true);
        this.workDirectoryName.setText(JUNIT_DEFAULT_EXCLUDED_PATHS);
        this.coverageIncludedProperty.clear();
        this.coverageExcludedProperty.clear();
        this.useVirtualMockButton.setSelection(false);
        this.useNoverifyButton.setSelection(false);
        this.useAsm.setSelection(true);
        this.useBcel.setSelection(false);
    }

    protected static String getJUnitDefaultExcludedPaths() {
        return JUNIT_DEFAULT_EXCLUDED_PATHS;
    }

    public boolean performOk() {
        this.saveProjectSettings();
        return true;
    }

    private void openFolderSelectionDialog() {
        try {
            IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
            IResource initSelection = null;
            if (DJUnitProjectPropertyPage.readWorkingDirectory(this.getJavaProject().getProject()) != null) {
                initSelection = workspaceRoot.findMember(this.addProjectPathString(DJUnitProjectPropertyPage.readWorkingDirectory(this.getJavaProject().getProject())));
            }
            Class[] classArray = new Class[2];
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.core.resources.IProject");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[0] = clazz;
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("org.eclipse.core.resources.IFolder");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[1] = clazz2;
            Class[] acceptedClasses = classArray;
            TypedElementSelectionValidator validator = new TypedElementSelectionValidator(acceptedClasses, false);
            IProject[] allProjects = workspaceRoot.getProjects();
            ArrayList<IProject> rejectedElements = new ArrayList<IProject>(allProjects.length);
            IProject currProject = this.getJavaProject().getProject();
            int i = 0;
            while (i < allProjects.length) {
                if (!allProjects[i].equals((Object)currProject)) {
                    rejectedElements.add(allProjects[i]);
                }
                ++i;
            }
            TypedViewerFilter filter = new TypedViewerFilter(acceptedClasses, rejectedElements.toArray());
            WorkbenchLabelProvider lp = new WorkbenchLabelProvider();
            WorkbenchContentProvider cp = new WorkbenchContentProvider();
            FolderSelectionDialog dialog = new FolderSelectionDialog(this.getShell(), (ILabelProvider)lp, (ITreeContentProvider)cp);
            dialog.setTitle(DJUnitMessages.getString("DJUnitProjectPropertyPage.coverage.label.workingdirectory"));
            dialog.setMessage(DJUnitMessages.getString("DJUnitProjectPropertyPage.coverage.message.choicefolder"));
            dialog.setInput((Object)workspaceRoot);
            dialog.setValidator((ISelectionStatusValidator)validator);
            dialog.addFilter((ViewerFilter)filter);
            dialog.setInitialSelection((Object)initSelection);
            dialog.setSorter((ViewerSorter)new ResourceSorter(1));
            if (dialog.open() == 0) {
                this.workDirectoryName.setText(this.getFolderName(dialog.getFirstResult()));
            }
        }
        catch (Throwable t) {
            DJUnitPlugin.log(t);
        }
    }

    private String getFolderName(Object result) throws CoreException {
        if (result instanceof Folder) {
            Folder folder = (Folder)result;
            String folderName = this.removeProjectPathString(folder.getLocation().toString());
            return folderName;
        }
        return JUNIT_DEFAULT_EXCLUDED_PATHS;
    }
}

