/*
 * Decompiled with CFR 0.152.
 */
package jp.co.dgic.eclipse.jdt.internal.junit.ui;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.AbstractSet;
import java.util.HashSet;
import jp.co.dgic.eclipse.jdt.internal.coverage.ui.CoverageReportView;
import jp.co.dgic.eclipse.jdt.internal.junit.ui.DJUnitDebugEventFilter;
import jp.co.dgic.eclipse.jdt.internal.junit.ui.DJUnitTestRunnerClient;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventFilter;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchListener;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.internal.junit.launcher.JUnitLaunchConfigurationConstants;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class DJUnitPlugin
extends AbstractUIPlugin
implements ILaunchListener {
    private static DJUnitPlugin fgPlugin = null;
    public static final String PLUGIN_ID = "jp.co.dgic.eclipse.jdt.djunit";
    public static final String ID_EXTENSION_POINT_TESTRUN_LISTENERS = "jp.co.dgic.eclipse.jdt.djunit.testRunListeners";
    public static final String ID_LAUNCH_CONFIG_TYPE = "jp.co.dgic.eclipse.jdt.djunit.launchconfig";
    public static final String TEST_SUPERCLASS_NAME = "junit.framework.TestCase";
    public static final String TEST_INTERFACE_NAME = "junit.framework.Test";
    private static URL fgIconBaseURL;
    private boolean isDJUnitTest = false;
    private DJUnitDebugEventFilter debugEventFilter = new DJUnitDebugEventFilter();
    private AbstractSet fTrackedLaunches = new HashSet(20);
    private CoverageReportView coverageView;
    private DJUnitTestRunnerClient djUnitClient;

    public DJUnitPlugin(IPluginDescriptor desc) {
        super(desc);
        fgPlugin = this;
        String pathSuffix = "icons/full/";
        try {
            fgIconBaseURL = new URL(Platform.getBundle((String)PLUGIN_ID).getEntry("/"), pathSuffix);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    public static DJUnitPlugin getDefault() {
        return fgPlugin;
    }

    public static Shell getActiveWorkbenchShell() {
        IWorkbenchWindow workBenchWindow = DJUnitPlugin.getActiveWorkbenchWindow();
        if (workBenchWindow == null) {
            return null;
        }
        return workBenchWindow.getShell();
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        if (fgPlugin == null) {
            return null;
        }
        IWorkbench workBench = fgPlugin.getWorkbench();
        if (workBench == null) {
            return null;
        }
        return workBench.getActiveWorkbenchWindow();
    }

    public static IWorkbenchPage getActivePage() {
        IWorkbenchWindow activeWorkbenchWindow = DJUnitPlugin.getActiveWorkbenchWindow();
        if (activeWorkbenchWindow == null) {
            return null;
        }
        return activeWorkbenchWindow.getActivePage();
    }

    public static String getPluginId() {
        return PLUGIN_ID;
    }

    protected void initializeDefaultPreferences(IPreferenceStore store) {
        super.initializeDefaultPreferences(store);
    }

    public static void log(Throwable e) {
        DJUnitPlugin.log((IStatus)new Status(4, DJUnitPlugin.getPluginId(), 4, "Error", e));
    }

    public static void log(IStatus status) {
        DJUnitPlugin.getDefault().getLog().log(status);
    }

    public static URL makeIconFileURL(String name) throws MalformedURLException {
        if (fgIconBaseURL == null) {
            throw new MalformedURLException();
        }
        return new URL(fgIconBaseURL, name);
    }

    static ImageDescriptor getImageDescriptor(String relativePath) {
        try {
            return ImageDescriptor.createFromURL((URL)DJUnitPlugin.makeIconFileURL(relativePath));
        }
        catch (MalformedURLException e) {
            return ImageDescriptor.getMissingImageDescriptor();
        }
    }

    public boolean isDJUnitTest() {
        return this.isDJUnitTest;
    }

    private void setDJUnitTest(boolean isDJUnitTest) {
        this.isDJUnitTest = isDJUnitTest;
    }

    public void launchRemoved(ILaunch launch) {
        DebugPlugin.getDefault().removeDebugEventFilter((IDebugEventFilter)this.debugEventFilter);
        this.fTrackedLaunches.remove(launch);
    }

    public void launchAdded(ILaunch launch) {
        this.fTrackedLaunches.add(launch);
    }

    public void connectDJUnitClient(IJavaProject javaProject, int port) {
        if (this.djUnitClient == null) {
            this.djUnitClient = new DJUnitTestRunnerClient();
        }
        if (this.djUnitClient.isRunning()) {
            this.djUnitClient.shutDown();
        }
        this.djUnitClient.startListening(port);
        CoverageReportView coverageView = this.showCoverageReportViewInActivePage(this.findCoverageReportView());
        if (coverageView != null) {
            this.coverageView = coverageView;
            coverageView.setProject(javaProject.getProject());
            coverageView.clearCoverage();
        }
    }

    public void shutDownClient() {
        if (this.djUnitClient == null) {
            return;
        }
        this.djUnitClient.shutDown();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private CoverageReportView showCoverageReportViewInActivePage(CoverageReportView coverageView) {
        CoverageReportView coverageReportView;
        IWorkbenchPage page;
        IWorkbenchPart activePart;
        block9: {
            block8: {
                CoverageReportView coverageReportView2;
                block7: {
                    activePart = null;
                    page = null;
                    try {
                        try {
                            if (coverageView != null) {
                                coverageReportView2 = coverageView;
                                Object var5_6 = null;
                                if (page == null) return coverageReportView2;
                                if (activePart == null) return coverageReportView2;
                                break block7;
                            }
                            page = DJUnitPlugin.getActivePage();
                            if (page == null) {
                                break block8;
                            }
                            activePart = page.getActivePart();
                            coverageReportView = (CoverageReportView)page.showView("jp.co.dgic.eclipse.jdt.coverage.CoverageReportView");
                            break block9;
                        }
                        catch (PartInitException pie) {
                            DJUnitPlugin.log(pie);
                            break block8;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var5_9 = null;
                        if (page == null) throw throwable;
                        if (activePart == null) throw throwable;
                        page.activate(activePart);
                        throw throwable;
                    }
                }
                page.activate(activePart);
                return coverageReportView2;
            }
            Object var5_7 = null;
            if (page == null) return null;
            if (activePart == null) return null;
            page.activate(activePart);
            return null;
        }
        Object var5_8 = null;
        if (page == null) return coverageReportView;
        if (activePart == null) return coverageReportView;
        page.activate(activePart);
        return coverageReportView;
    }

    private CoverageReportView findCoverageReportView() {
        IWorkbenchPage page = DJUnitPlugin.getActivePage();
        if (page == null) {
            return null;
        }
        return (CoverageReportView)page.findView("jp.co.dgic.eclipse.jdt.coverage.CoverageReportView");
    }

    public static CoverageReportView getCoverageReportView() {
        return DJUnitPlugin.getDefault().coverageView;
    }

    private boolean isLaunchedByDJUnit(ILaunch launch) {
        try {
            String id = launch.getLaunchConfiguration().getType().getIdentifier();
            if (ID_LAUNCH_CONFIG_TYPE.equals(id)) {
                return true;
            }
        }
        catch (CoreException e) {
            DJUnitPlugin.log(e);
        }
        return false;
    }

    public void launchChanged(ILaunch launch) {
        boolean isDJUnitLaunch = this.isLaunchedByDJUnit(launch);
        this.setDJUnitTest(isDJUnitLaunch);
        if (!isDJUnitLaunch) {
            return;
        }
        if ("debug".equalsIgnoreCase(launch.getLaunchMode())) {
            DebugPlugin.getDefault().addDebugEventFilter((IDebugEventFilter)this.debugEventFilter);
        }
        if (!this.fTrackedLaunches.contains(launch)) {
            return;
        }
        ILaunchConfiguration config = launch.getLaunchConfiguration();
        if (config == null) {
            return;
        }
        final IJavaProject javaProject = JUnitLaunchConfigurationConstants.getJavaProject((ILaunchConfiguration)config);
        if (javaProject == null) {
            return;
        }
        String portStr = launch.getAttribute("jp.co.dgic.eclipse.jdt.djunit.client.port");
        if (portStr == null) {
            return;
        }
        try {
            final int port = Integer.parseInt(portStr);
            this.fTrackedLaunches.remove(launch);
            DJUnitPlugin.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    DJUnitPlugin.this.connectDJUnitClient(javaProject, port);
                }
            });
        }
        catch (NumberFormatException e) {
            return;
        }
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        launchManager.addLaunchListener((ILaunchListener)this);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void stop(BundleContext context) throws Exception {
        try {
            ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
            launchManager.removeLaunchListener((ILaunchListener)this);
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            super.stop(context);
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        super.stop(context);
    }

    public static Display getDisplay() {
        Shell shell = DJUnitPlugin.getActiveWorkbenchShell();
        if (shell != null) {
            return shell.getDisplay();
        }
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }
}

