/*
 * Decompiled with CFR 0.152.
 */
package jp.co.dgic.djunit.ant;

import java.io.File;
import java.io.OutputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Vector;
import jp.co.dgic.djunit.ant.DJUnitBaseTest;
import jp.co.dgic.djunit.ant.DJUnitBatchTest;
import jp.co.dgic.djunit.ant.DJUnitFormatterElement;
import jp.co.dgic.djunit.ant.DJUnitJvmArgs;
import jp.co.dgic.djunit.ant.DJUnitTest;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.ExecuteWatchdog;
import org.apache.tools.ant.taskdefs.LogOutputStream;
import org.apache.tools.ant.taskdefs.optional.junit.Enumerations;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.CommandlineJava;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.types.Environment;
import org.apache.tools.ant.types.Path;

public class DJUnitTask
extends Task {
    private static final String TEST_RUNNER_CLASS_NAME = "jp.co.dgic.djunit.ant.DJUnitRunner";
    private CommandlineJava commandline = new CommandlineJava();
    private Vector tests = new Vector();
    private Vector batchTests = new Vector();
    private Vector formatters = new Vector();
    private File dir = null;
    private Integer timeout = null;
    private boolean summary = false;
    private String summaryValue = "";
    private boolean newEnvironment = false;
    private Environment env = new Environment();
    private boolean includeAntRuntime = true;
    private Path antRuntimeClasses = null;
    private boolean showOutput = false;
    private DJUnitJvmArgs djUnitJvmArgs = new DJUnitJvmArgs();

    public void setTargetSrcDir(String targetSrcDir) {
        this.djUnitJvmArgs.setTargetSrcDir(targetSrcDir);
    }

    public void setCoverage(boolean useCoverage) {
        this.djUnitJvmArgs.setUseCoverage(useCoverage);
    }

    public void setVirtualMock(boolean useVirtualMock) {
        this.djUnitJvmArgs.setUseVirtualMock(useVirtualMock);
    }

    public void setExcludesPath(String excludesPath) {
        this.djUnitJvmArgs.addExcludesPaths(excludesPath);
    }

    public void setIgnoreLibrary(boolean isIgnoreLibrary) {
        this.djUnitJvmArgs.setIgnoreLibrary(isIgnoreLibrary);
    }

    public void setNotIgnorePattern(String notIgnorePatterns) {
        this.djUnitJvmArgs.setNotIgnorePatterns(notIgnorePatterns);
    }

    public void setUseNoverify(boolean useNoverify) {
        this.djUnitJvmArgs.setUseNoverify(useNoverify);
    }

    public void setUseBcel(boolean useBcel) {
        this.djUnitJvmArgs.setUseBcel(useBcel);
    }

    public void setFiltertrace(boolean value) {
        Enumeration enumeration = this.allTests();
        while (enumeration.hasMoreElements()) {
            DJUnitBaseTest test = (DJUnitBaseTest)enumeration.nextElement();
            test.setFiltertrace(value);
        }
    }

    public void setHaltonerror(boolean value) {
        Enumeration enumeration = this.allTests();
        while (enumeration.hasMoreElements()) {
            DJUnitBaseTest test = (DJUnitBaseTest)enumeration.nextElement();
            test.setHaltonerror(value);
        }
    }

    public void setErrorProperty(String propertyName) {
        Enumeration enumeration = this.allTests();
        while (enumeration.hasMoreElements()) {
            DJUnitBaseTest test = (DJUnitBaseTest)enumeration.nextElement();
            test.setErrorProperty(propertyName);
        }
    }

    public void setHaltonfailure(boolean value) {
        Enumeration enumeration = this.allTests();
        while (enumeration.hasMoreElements()) {
            DJUnitBaseTest test = (DJUnitBaseTest)enumeration.nextElement();
            test.setHaltonfailure(value);
        }
    }

    public void setFailureProperty(String propertyName) {
        Enumeration enumeration = this.allTests();
        while (enumeration.hasMoreElements()) {
            DJUnitBaseTest test = (DJUnitBaseTest)enumeration.nextElement();
            test.setFailureProperty(propertyName);
        }
    }

    public void setPrintsummary(SummaryAttribute value) {
        this.summaryValue = value.getValue();
        this.summary = value.asBoolean();
    }

    public void setTimeout(Integer value) {
        this.timeout = value;
    }

    public void setMaxmemory(String max) {
        this.commandline.setMaxmemory(max);
    }

    public void setJvm(String value) {
        this.commandline.setVm(value);
    }

    public Commandline.Argument createJvmarg() {
        return this.commandline.createVmArgument();
    }

    public void setDir(File dir) {
        this.dir = dir;
    }

    public void addSysproperty(Environment.Variable sysp) {
        this.commandline.addSysproperty(sysp);
    }

    public Path createClasspath() {
        return this.commandline.createClasspath(this.project).createPath();
    }

    public void addEnv(Environment.Variable var) {
        this.env.addVariable(var);
    }

    public void setNewenvironment(boolean newenv) {
        this.newEnvironment = newenv;
    }

    public void addTest(DJUnitTest test) {
        this.tests.addElement(test);
    }

    public DJUnitBatchTest createBatchTest() {
        DJUnitBatchTest test = new DJUnitBatchTest(this.project);
        this.batchTests.addElement(test);
        return test;
    }

    public void addFormatter(DJUnitFormatterElement fe) {
        this.formatters.addElement(fe);
    }

    public void setIncludeantruntime(boolean b) {
        this.includeAntRuntime = b;
    }

    public void setShowOutput(boolean showOutput) {
        this.showOutput = showOutput;
    }

    public DJUnitTask() throws Exception {
        this.commandline.setClassname(TEST_RUNNER_CLASS_NAME);
    }

    public void init() {
        this.antRuntimeClasses = new Path(this.getProject());
        this.addClasspathEntry("/junit/framework/TestCase.class");
        this.addClasspathEntry("/org/apache/tools/ant/Task.class");
        this.addClasspathEntry("/org/apache/tools/ant/launch/AntMain.class");
        this.addClasspathEntry("/org/apache/tools/ant/taskdefs/optional/junit/JUnitTestRunner.class");
        this.addClasspathEntry("/" + TEST_RUNNER_CLASS_NAME.replace('.', '/') + ".class");
        this.djUnitJvmArgs.setBaseDir(this.getProject().getBaseDir());
    }

    public void execute() throws BuildException {
        Enumeration list = this.getIndividualTests();
        while (list.hasMoreElements()) {
            DJUnitTest test = (DJUnitTest)list.nextElement();
            if (!test.shouldRun(this.project)) continue;
            this.execute(test);
        }
    }

    protected void execute(DJUnitTest arg) throws BuildException {
        boolean failureOccurredHere;
        DJUnitTest test = (DJUnitTest)arg.clone();
        if (test.getTodir() == null) {
            test.setTodir(this.project.resolveFile("."));
        }
        if (test.getOutfile() == null) {
            test.setOutfile("TEST-" + test.getName());
        }
        int exitValue = 2;
        boolean wasKilled = false;
        test.setFork(true);
        ExecuteWatchdog watchdog = this.createWatchdog();
        exitValue = this.executeAsForked(test, watchdog);
        if (watchdog != null) {
            wasKilled = watchdog.killedProcess();
        }
        boolean errorOccurredHere = exitValue == 2;
        boolean bl = failureOccurredHere = exitValue != 0;
        if (errorOccurredHere || failureOccurredHere) {
            if (errorOccurredHere && test.getHaltonerror() || failureOccurredHere && test.getHaltonfailure()) {
                throw new BuildException("Test " + test.getName() + " failed" + (wasKilled ? " (timeout)" : ""), this.location);
            }
            this.log("TEST " + test.getName() + " FAILED" + (wasKilled ? " (timeout)" : ""), 0);
            if (errorOccurredHere && test.getErrorProperty() != null) {
                this.project.setNewProperty(test.getErrorProperty(), "true");
            }
            if (failureOccurredHere && test.getFailureProperty() != null) {
                this.project.setNewProperty(test.getFailureProperty(), "true");
            }
        }
    }

    /*
     * Exception decompiling
     */
    private int executeAsForked(DJUnitTest test, ExecuteWatchdog watchdog) throws BuildException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [3 : 718->721)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected ExecuteWatchdog createWatchdog() throws BuildException {
        if (this.timeout == null) {
            return null;
        }
        return new ExecuteWatchdog(this.timeout.intValue());
    }

    protected OutputStream getDefaultOutput() {
        return new LogOutputStream((Task)this, 2);
    }

    protected Enumeration getIndividualTests() {
        int count = this.batchTests.size();
        Enumeration[] enums = new Enumeration[count + 1];
        int i = 0;
        while (i < count) {
            DJUnitBatchTest batchtest = (DJUnitBatchTest)this.batchTests.elementAt(i);
            enums[i] = batchtest.elements();
            ++i;
        }
        enums[enums.length - 1] = this.tests.elements();
        return Enumerations.fromCompound((Enumeration[])enums);
    }

    protected Enumeration allTests() {
        Enumeration[] enums = new Enumeration[]{this.tests.elements(), this.batchTests.elements()};
        return Enumerations.fromCompound((Enumeration[])enums);
    }

    private DJUnitFormatterElement[] mergeFormatters(DJUnitTest test) {
        Vector feVector = (Vector)this.formatters.clone();
        test.addFormattersTo(feVector);
        Object[] feArray = new DJUnitFormatterElement[feVector.size()];
        feVector.copyInto(feArray);
        return feArray;
    }

    protected File getOutput(DJUnitFormatterElement fe, DJUnitTest test) {
        if (fe.getUseFile()) {
            String filename = String.valueOf(test.getOutfile()) + fe.getExtension();
            File destFile = new File(test.getTodir(), filename);
            String absFilename = destFile.getAbsolutePath();
            return this.project.resolveFile(absFilename);
        }
        return null;
    }

    protected void addClasspathEntry(String resource) {
        URL url = ((Object)((Object)this)).getClass().getResource(resource);
        if (url != null) {
            String u = url.toString();
            if (u.startsWith("jar:file:")) {
                int pling = u.indexOf("!");
                String jarName = u.substring(9, pling);
                this.log("Found " + jarName, 4);
                this.antRuntimeClasses.createPath().setLocation(new File(new File(jarName).getAbsolutePath()));
            } else if (u.startsWith("file:")) {
                int tail = u.indexOf(resource);
                String dirName = u.substring(5, tail);
                this.log("Found " + dirName, 4);
                this.antRuntimeClasses.createPath().setLocation(new File(new File(dirName).getAbsolutePath()));
            } else {
                this.log("Don't know how to handle resource URL " + u, 4);
            }
        } else {
            this.log("Couldn't find " + resource, 4);
        }
    }

    public static class SummaryAttribute
    extends EnumeratedAttribute {
        public String[] getValues() {
            return new String[]{"true", "yes", "false", "no", "on", "off", "withOutAndErr"};
        }

        public boolean asBoolean() {
            String value = this.getValue();
            return "true".equals(value) || "on".equals(value) || "yes".equals(value) || "withOutAndErr".equals(value);
        }
    }
}

