/**
 * www.jcoverage.com
 * Copyright (C)2003 jcoverage ltd.
 *
 * This file is part of jcoverage.
 *
 * jcoverage is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published
 * by the Free Software Foundation; either version 2 of the License,
 * or (at your option) any later version.
 *
 * jcoverage is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with jcoverage; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 *
 */
package com.jcoverage.util;

import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.LineNumberGen;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.Type;

public class MethodGenHelper {
  final MethodGen mg;

  public MethodGenHelper(MethodGen mg) {
    this.mg=mg;
  }

  public MethodGen getMethodGen() {
    return mg;
  }

  public boolean hasLineNumber(InstructionHandle handle) {
    LineNumberGen[] lineNumberGen=mg.getLineNumbers();
    for(int i=0;i<lineNumberGen.length;i++) {
      if(lineNumberGen[i].containsTarget(handle)) {
        return true;
      }
    }
    return false;
  }

  public int getLineNumber(InstructionHandle handle) {
    LineNumberGen[] lineNumberGen=mg.getLineNumbers();
    for(int i=0;i<lineNumberGen.length;i++) {
      if(lineNumberGen[i].containsTarget(handle)) {
        return lineNumberGen[i].getSourceLine();
      }
    }
    return 0;
  }

  public boolean isVoidReturningMethod() {
    return mg.getReturnType().equals(Type.VOID);
  }
}
