/**
 * www.jcoverage.com
 * Copyright (C)2003 jcoverage ltd.
 *
 * This file is part of jcoverage.
 *
 * jcoverage is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published
 * by the Free Software Foundation; either version 2 of the License,
 * or (at your option) any later version.
 *
 * jcoverage is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with jcoverage; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 *
 */
package com.jcoverage.tool.merge;

import com.jcoverage.coverage.InstrumentationPersistence;
import com.jcoverage.coverage.Version;

import gnu.getopt.Getopt;
import gnu.getopt.LongOpt;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;

public class Main extends InstrumentationPersistence {

  Main(String[] args) {
    LongOpt[] longOpts=new LongOpt[2];
    longOpts[0]=new LongOpt("instrumentation",LongOpt.REQUIRED_ARGUMENT,null,'i');
    longOpts[1]=new LongOpt("output",LongOpt.REQUIRED_ARGUMENT,null,'o');

    Getopt g=new Getopt(getClass().getName(),args,":i:o:",longOpts);
    int c;

    File destDir=new File(System.getProperty("user.dir"));

    while((c=g.getopt())!=-1) {
      switch(c) {
      case 'i':
        System.out.println("jcoverage loading: "+g.getOptarg());
        try {
          merge(loadInstrumentation(new FileInputStream(g.getOptarg())));
        } catch(FileNotFoundException ex) {
        }
        break;

      case 'o':
        destDir=new File(g.getOptarg());
        destDir.mkdirs();
        break;
      }
    }

    saveInstrumentation(destDir);
  }


  public static void main(String[] args) {
    System.out.println("jcoverage "+Version.VERSION_STRING+" copyright (c)2003 jcoverage ltd. http://jcoverage.com/");
    System.out.println("jcoverage is licensed under the GNU General Public License");
    System.out.println("jcoverage comes with ABSOLUTELY NO WARRANTY");
    System.out.println("jcoverage instrumentation session merge tool");
    new Main(args);
  }
}
