/**
 * www.jcoverage.com
 * Copyright (C)2003 jcoverage ltd.
 *
 * This file is part of jcoverage.
 *
 * jcoverage is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published
 * by the Free Software Foundation; either version 2 of the License,
 * or (at your option) any later version.
 *
 * jcoverage is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with jcoverage; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 *
 */
package com.jcoverage.reporting.html;

import java.io.*;
import java.util.*;

import com.jcoverage.reporting.Column;
import com.jcoverage.reporting.FormattingContext;
import com.jcoverage.reporting.Line;
import com.jcoverage.reporting.Page;

/**
 *
 */
public class ReportTable implements Writable {
  
  public final static ColumnRenderer DEFAULT_COLUMN_RENDERER=new DefaultColumnRenderer();

  Page page;
  Set records;
  Column[] columns;
  FormattingContext ctx;

  ColumnRenderer[] columnRenderers;
  Map registeredDefaultColumnRenderers=new HashMap();

  public ReportTable(Page page,Set records,Column[] columns,FormattingContext ctx) {
    this.page=page;
    this.records=records;
    this.columns=columns;
    this.ctx=ctx;
    columnRenderers=new ColumnRenderer[columns.length];
  }

  public void setColumnRenderer(Column column,ColumnRenderer renderer) {
    registeredDefaultColumnRenderers.put(column,renderer);
  }

  public void setColumnRenderer(Column column,ColumnRenderer renderer,int colnum) {
    if (columns[colnum].equals(column)) {
      columnRenderers[colnum]=renderer;
    } else {
      throw new IllegalArgumentException("Column number does not correspond to given column. Given column is "+column+" but column number corresponds to column "+columns[colnum]);
    }
  }

  void fillColumnRenderers() {
    for (int i=0;i<columnRenderers.length;i++) {
      if (columnRenderers[i]!=null) {
        continue;
      }
      ColumnRenderer defaultColumnRenderer=(ColumnRenderer)registeredDefaultColumnRenderers.get(columns[i]);
      if (defaultColumnRenderer!=null) {
        columnRenderers[i]=defaultColumnRenderer;
      } else {
        columnRenderers[i]=DEFAULT_COLUMN_RENDERER;
      }
    }
  }

  public void writeTo(PrintWriter writer) {

    fillColumnRenderers();

    writer.println("<table cellpadding=\"2\" cellspacing=\"0\" width=\"85%\">");

    writer.print("<tr>");
    for (int i=0;i<columns.length;i++) {
      columnRenderers[i].renderTitle(ctx,writer,columns[i],i==columns.length-1);
    }
    writer.println("</tr>");

    int rownum=0;
    for (Iterator it=records.iterator();it.hasNext();) {

      String cssClass=(rownum%2==0?"yin":"yang");
      rownum++;

      Line line=(Line)it.next();
      Page detail=line.getDetailPage();
      String href=null;

      if(detail!=null) {
        href=ctx.getCollator().getPathToPage(ctx,detail,page);
      }
      
      writer.println("<tr class=\""+cssClass+"\">");
      for (int i=0;i<columns.length;i++) {
        columnRenderers[i].renderField(ctx,writer,columns[i],line,href);
      }
                              
      writer.println("</tr>");
    }

    writer.println("</table>");

  }

}
