/**
 * www.jcoverage.com
 * Copyright (C)2003 jcoverage ltd.
 *
 * This file is part of jcoverage.
 *
 * jcoverage is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published
 * by the Free Software Foundation; either version 2 of the License,
 * or (at your option) any later version.
 *
 * jcoverage is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with jcoverage; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 *
 */
package com.jcoverage.reporting.html;

import java.io.PrintWriter;

import com.jcoverage.reporting.Column;
import com.jcoverage.reporting.FormattingContext;
import com.jcoverage.reporting.Line;
import com.jcoverage.reporting.Page;

/**
 *
 */
public class RedGreenIndicator extends DefaultColumnRenderer implements ColumnRenderer {
  
  public RedGreenIndicator(String label) {
    super(label);
  }

  public void renderField(FormattingContext ctx,PrintWriter writer,Column column,Line line,String href) {
    int greenValue=((Integer)line.getField(column)).intValue();
    int redValue=100-greenValue;

    String greenGifPath=ctx.getCollator().getPathToResource(ctx,"images/green.gif",getPage(line));
    String redGifPath=ctx.getCollator().getPathToResource(ctx,"images/red.gif",getPage(line));

    writer.print("<td>");
    if (greenValue>0) {
      writer.print("<img src=\""+greenGifPath+"\" height=\"10\" width=\""+greenValue+"\"/>");
    }
    if (redValue>0) {
      writer.print("<img src=\""+redGifPath+"\" height=\"10\" width=\""+redValue+"\"/>");
    }
    writer.println("</td>");
  }
  
  public String getWidth() {
    return "100";
  }

  /**
   * We need to find the location of the page we are generating.  If
   * our line has an owning page, we can use that, otherwise we must
   * be the top-level line, which means we should use the detail
   * page. It's a bit contrived, but should work for most situations.
   */
  Page getPage(Line line) {
    Page page=line.getOwner();
    if (page==null) {
      page=line.getDetailPage();
    }
    return page;
  }

}
