/**
 * www.jcoverage.com
 * Copyright (C)2003 jcoverage ltd.
 *
 * This file is part of jcoverage.
 *
 * jcoverage is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published
 * by the Free Software Foundation; either version 2 of the License,
 * or (at your option) any later version.
 *
 * jcoverage is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with jcoverage; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 *
 */
package com.jcoverage.reporting.html;

import java.io.PrintWriter;

/**
 *
 */
public class Html extends HtmlBlockElement {
  
  Head head=new Head();
  Body body=new Body();

  public Html() {
    super("html");
  }

  public Head getHead() {
    return head;
  }

  public Body getBody() {
    return body;
  }

  public void setTitle(String title) {
    getHead().setTitle(title);
  }

  public void add(Writable writable) {
    getBody().add(writable);
  }

  public void add(String pcdata) {
    getBody().add(pcdata);
  }

  /**
   * Writes this HTML document to the given writer.  Since this would
   * always finish the output, the writer is closed afterwards.
   */
  public void writeTo(PrintWriter writer) {
    openBlock(writer);
    getHead().writeTo(writer);
    getBody().writeTo(writer);
    closeBlock(writer);
    writer.close();
  }

}
