/**
 * www.jcoverage.com
 * Copyright (C)2003 jcoverage ltd.
 *
 * This file is part of jcoverage.
 *
 * jcoverage is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published
 * by the Free Software Foundation; either version 2 of the License,
 * or (at your option) any later version.
 *
 * jcoverage is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with jcoverage; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 *
 */
package com.jcoverage.reporting.html;

import java.io.PrintWriter;

import com.jcoverage.reporting.Column;
import com.jcoverage.reporting.FormattingContext;
import com.jcoverage.reporting.Line;

/**
 * This class provides a custom html renderer that knows how to render
 * a certain table column in a particular way.
 * Instances can be registered with a column in the {@link ReportTable}.
 */
public interface ColumnRenderer {
  
  void renderField(FormattingContext ctx,PrintWriter writer,Column column,Line line,String href);
  void renderTitle(FormattingContext ctx,PrintWriter writer,Column column,boolean remainder);
  
}
