/**
 * www.jcoverage.com
 * Copyright (C)2003 jcoverage ltd.
 *
 * This file is part of jcoverage.
 *
 * jcoverage is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published
 * by the Free Software Foundation; either version 2 of the License,
 * or (at your option) any later version.
 *
 * jcoverage is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with jcoverage; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 *
 */
package com.jcoverage.reporting;

import java.util.*;

/**
 * A page containing information at the same report level.
 */
public interface Page extends Closeable {

  /**
   * Create a new line in the page.  Lines can fall into categories,
   * used for tables and sectioning.  This information is used by
   * formats, so they can request lines by category.
   */
  Line createLine(LineCategory category);

  /**
   * Add a reference to a line. Unlike the {@link
   * #createLine(LineCategory)} method, no connections are made
   * between this page and line.
   */
  void addLineReference(Line line,LineCategory category);

  Line lookupLineByField(LineCategory category,Column column,Object value);

  /**
   * The page can 'contain' any number of categories (tables) which,
   * in turn, contain any number of lines.  This method provides
   * access to those lines.
   * @return the lines stored in this page against the category, or an
   * empty set. Should never return null.
   */
  Set getLines(LineCategory category);

  void setReport(Report report);

  /**
   * @return the line that summarizes this detail page, null if this
   * is not a detail page. The terminology of master and detail comes
   * from the database world where heirarchical reports which show
   * information in a parent-child format are often referred to as
   * master-detail reports.
   */
  Line getMasterLine();

  /**
   * @see #getMasterLine()
   */
  void setMasterLine(Line masterLine);

  /**
   * Get the line categories that are valid for this page.
   */
  LineCategory[] getCategories();

  /*
   * TODO: This isn't optimal in terms of memory usage - categories
   * are common to all pages of a particular type, so a PageDefinition
   * class or similar should be invented.
   */
  void addCategory(LineCategory category);

  String getLabel();

}
