/**
 * www.jcoverage.com
 * Copyright (C)2003 jcoverage ltd.
 *
 * This file is part of jcoverage.
 *
 * jcoverage is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published
 * by the Free Software Foundation; either version 2 of the License,
 * or (at your option) any later version.
 *
 * jcoverage is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with jcoverage; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 *
 */
package com.jcoverage.reporting;

/**
 *
 */
public interface MultiViewCollator extends Collator {
  
  /**
   * Use this method to get a path for a page which will implicitly change the view.
   * @param ctx the formatting context.
   * @param page the page that is being referenced.
   * @param from the current page, which will contain the reference.
   * @param toView the new view to set.
   * @return the path of the page that is being referenced.
   */
  String getPathToPage(ViewFormattingContext ctx,Page page,Page from,View toView);

}
