/**
 * www.jcoverage.com
 * Copyright (C)2003 jcoverage ltd.
 *
 * This file is part of jcoverage.
 *
 * jcoverage is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published
 * by the Free Software Foundation; either version 2 of the License,
 * or (at your option) any later version.
 *
 * jcoverage is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with jcoverage; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 *
 */
package com.jcoverage.reporting;

import java.util.Collection;

/**
 * A line of information in a page of a report.
 */
public interface Line extends Closeable {
    
  /**
   * This method signifies more detail is available for this line in a
   * separate page.
   * @return a new page, ready for lines of more detailed information
   * to be added.
   */
  Page openDetailPage();

  /**
   * Get the detail page if one exists. This method does not create a
   * detail page, if you want to do this you should use {@link
   * #openDetailPage()}.
   */
  Page getDetailPage();

  void setOwner(Page page);
  Page getOwner();
  void setReport(Report report);

  /**
   * Fields can be set on a line.
   * @param fieldtype the name of the field type. This must be a valid type
   * with respect to this instance's {@link LineCategory}.
   * @param value the value of the field. Again, this must be of
   * the correct type as determined by the category.
   */
  void setField(Column col,Object value) throws IllegalArgumentException;

  void setField(Column col,int value) throws IllegalArgumentException;

  void setField(Column col,double value) throws IllegalArgumentException;

  void setField(Column col,boolean value) throws IllegalArgumentException;

  /**
   * @param col the given column.
   * @return the value of the given column, the type of which is
   * determined by the {@link LineCategory}.
   */
  Object getField(Column col);

  /**
   * Instances of this class should record their {@linkplain
   * LineCategory category} if they want to validate values of fields
   * set with the {@link #setField(Column,Object) setField()} methods.
   * 
   * <p>
   *
   * Reports that are not derived from {@link AbstractPage}, or
   * override {@link AbstractPage#createLine(LineCategory)} should
   * always call this method on newly created {@link Line} instances
   * they create.
   */
  void setCategory(LineCategory category);

    
}
