/**
 * www.jcoverage.com
 * Copyright (C)2003 jcoverage ltd.
 *
 * This file is part of jcoverage.
 *
 * jcoverage is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published
 * by the Free Software Foundation; either version 2 of the License,
 * or (at your option) any later version.
 *
 * jcoverage is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with jcoverage; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 *
 */
package com.jcoverage.reporting;

import java.util.*;

/**
 *
 */
public abstract class AbstractReport implements Report {
  
  Collator collator;
  Line line;
  
  public void setCollator(Collator collator) {
    this.collator=collator;
  }

  public Collator getCollator() {
    return collator;
  }

  public final Page createFrontPage() {
    Line line=createMasterLine();
    if (line==null) {
      throw new NullPointerException("This class ("+getClass()+") must return a valid non-null object from the instantiateMasterLine method");
    }
    return line.openDetailPage();
  }

  public final Line createMasterLine() {
    line=instantiateMasterLine();
    if (line!=null) {
      line.setReport(this);
    }
    return line;
  }

  protected Line instantiateMasterLine() {
    return null;
  }

}
