/**
 * www.jcoverage.com
 * Copyright (C)2003 jcoverage ltd.
 *
 * This file is part of jcoverage.
 *
 * jcoverage is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published
 * by the Free Software Foundation; either version 2 of the License,
 * or (at your option) any later version.
 *
 * jcoverage is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with jcoverage; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 *
 */
package com.jcoverage.coverage.reporting.html;

import java.io.*;
import java.util.*;

import com.jcoverage.coverage.reporting.collation.JavaFileLine;
import com.jcoverage.coverage.reporting.collation.PackageSummaryPage;
import com.jcoverage.coverage.reporting.collation.ReportSummaryPackageLine;
import com.jcoverage.coverage.reporting.collation.ReportSummaryPage;
import com.jcoverage.reporting.Column;
import com.jcoverage.reporting.FormattingContext;
import com.jcoverage.reporting.MultiViewCollator;
import com.jcoverage.reporting.Page;
import com.jcoverage.reporting.ReportingException;
import com.jcoverage.reporting.View;
import com.jcoverage.reporting.ViewFormattingContext;
import com.jcoverage.reporting.html.ColumnRenderer;
import com.jcoverage.reporting.html.CssColumnRenderer;
import com.jcoverage.reporting.html.H1;
import com.jcoverage.reporting.html.H2;
import com.jcoverage.reporting.html.Html;
import com.jcoverage.reporting.html.RedGreenIndicator;
import com.jcoverage.reporting.html.ReportTable;

/**
 *
 */
public class PackageSummaryFormat extends CommonFormat {
  
  public void formatPage(FormattingContext ctx,Page page) throws ReportingException {
    throw new IllegalStateException(getClass().getName()+" formatPage method must be given a ViewFormattingContext because views are involved");
  }

  public void formatPage(ViewFormattingContext ctx,Page page) throws ReportingException {

    String name=(String)page.getMasterLine().getField(ReportSummaryPackageLine.COLUMN_PACKAGE_NAME);

    Html html=new Html();
    html.setTitle("jcoverage package summary for "+name);
    buildHeader(html);

    NavigationBar navbar=new NavigationBar(ctx,page);
    html.add(navbar);

    html.add(new H1("Package summary for "+name));

    html.add(new H2("Overall package"));
    
    Set lines=new HashSet();
    lines.add(page.getMasterLine());
    html.add(new PackagesTable(page,lines,ctx));

    addViews(ctx,page,html);

    html.add(new H2("Classes"));
    lines=page.getLines(PackageSummaryPage.CATEGORY_JAVAFILES);
    if (ctx.getCurrentView()!=null) {
      lines=ctx.getCurrentView().orderLines(lines,PackageSummaryPage.CATEGORY_JAVAFILES);
    }

    html.add(new JavaFilesTable(page,lines,ctx));

    html.add("<p>");
    html.add(navbar);
    buildFooter(html);
    html.writeTo(getWriter(ctx,page));
  }

}
