/**
 * www.jcoverage.com
 * Copyright (C)2003 jcoverage ltd.
 *
 * This file is part of jcoverage.
 *
 * jcoverage is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published
 * by the Free Software Foundation; either version 2 of the License,
 * or (at your option) any later version.
 *
 * jcoverage is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with jcoverage; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 *
 */
package com.jcoverage.coverage.reporting.html;

import java.util.Set;

import com.jcoverage.coverage.reporting.collation.JavaFileLine;
import com.jcoverage.reporting.Column;
import com.jcoverage.reporting.FormattingContext;
import com.jcoverage.reporting.Page;
import com.jcoverage.reporting.html.ColumnRenderer;
import com.jcoverage.reporting.html.CssColumnRenderer;
import com.jcoverage.reporting.html.RedGreenIndicator;
import com.jcoverage.reporting.html.ReportTable;

/**
 *
 */
public class JavaFilesTable extends ReportTable {
  
  static Column[] COLUMNS=new Column[]{JavaFileLine.COLUMN_FILE_NAME,
                                       JavaFileLine.COLUMN_SOURCE_LINES,
                                       JavaFileLine.COLUMN_COVERAGE_PERCENT,
                                       JavaFileLine.COLUMN_COVERAGE_PERCENT,
                                       JavaFileLine.COLUMN_BRANCH_COVERAGE_PERCENT,
                                       JavaFileLine.COLUMN_BRANCH_COVERAGE_PERCENT};

  public JavaFilesTable(Page page,Set records,FormattingContext ctx) {
    super(page,records,COLUMNS,ctx);
    setColumnRenderer(JavaFileLine.COLUMN_FILE_NAME,new CssColumnRenderer("filename"));
    setColumnRenderer(JavaFileLine.COLUMN_SOURCE_LINES,new CssColumnRenderer("lines"));
    setColumnRenderer(JavaFileLine.COLUMN_COVERAGE_PERCENT,new PercentColumnRenderer("coverage"));
    setColumnRenderer(JavaFileLine.COLUMN_COVERAGE_PERCENT,new RedGreenIndicator("indicator"),3);
    setColumnRenderer(JavaFileLine.COLUMN_BRANCH_COVERAGE_PERCENT,new PercentColumnRenderer("coverage"));
    setColumnRenderer(JavaFileLine.COLUMN_BRANCH_COVERAGE_PERCENT,new RedGreenIndicator("indicator"),5);
  }

}
