/**
 * www.jcoverage.com
 * Copyright (C)2003 jcoverage ltd.
 *
 * This file is part of jcoverage.
 *
 * jcoverage is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published
 * by the Free Software Foundation; either version 2 of the License,
 * or (at your option) any later version.
 *
 * jcoverage is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with jcoverage; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 *
 */
package com.jcoverage.coverage.reporting.html;

import com.jcoverage.reporting.MultiViewCollator;
import com.jcoverage.reporting.Page;
import com.jcoverage.reporting.View;
import com.jcoverage.reporting.ViewFormattingContext;
import com.jcoverage.reporting.html.AbstractHtmlFormat;
import com.jcoverage.reporting.html.H2;
import com.jcoverage.reporting.html.Html;
import com.jcoverage.reporting.html.Style;

import com.jcoverage.coverage.Version;

/**
 *
 */
public abstract class CommonFormat extends AbstractHtmlFormat {
  
  protected void buildHeader(Html html) {
    html.getHead().add(new Style(getClass().getResourceAsStream("style.css")));
    html.add("<img src=\"http://jcoverage.com/images/shim"+Version.VERSION_STRING+".gif\" width=\"1\" height=\"1\">");
  }
  
  protected void buildFooter(Html html) {
    html.getBody().add("<table width=\"100%\" cellpadding=\"0\" cellspacing=\"0\"><tr valign=\"top\"><td>");
    html.getBody().add("<p class=\"legalleft\">");
    html.getBody().add("this report was generated by version "+Version.VERSION_STRING+" of jcoverage.<br>");
    html.getBody().add("visit <a href=\"http://www.jcoverage.com\">www.jcoverage.com</a> for updates.<br>");
    html.getBody().add("</td><td>");
    html.getBody().add("<p class=\"legalright\">");
    html.getBody().add("copyright &copy; 2003, jcoverage ltd. all rights reserved.<br>");
    html.getBody().add("Java is a trademark of Sun Microsystems, Inc. in the United States and other countries.<br>");
    html.getBody().add("</td></tr></table>");
  }
  
  protected void addViews(ViewFormattingContext ctx,Page page,Html html) {
    MultiViewCollator collator=(MultiViewCollator)ctx.getCollator();
    View[] views=ctx.getViews();
    html.add(new H2("Set view:"));
    html.add("<p class=\"view\">");
    for (int i=0;i<views.length;i++) {
      if (ctx.getCurrentView().equals(views[i])) {
        html.getBody().add("<b>"+views[i].getLabel()+"</b>");
      } else {
        String href=collator.getPathToPage(ctx,page,page,views[i]);
        html.getBody().add("<a href=\""+href+"\">"+views[i].getLabel()+"</a>");
      }
      html.add("<br>");
    }
  }
}
