/**
 * www.jcoverage.com
 * Copyright (C)2003 jcoverage ltd.
 *
 * This file is part of jcoverage.
 *
 * jcoverage is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published
 * by the Free Software Foundation; either version 2 of the License,
 * or (at your option) any later version.
 *
 * jcoverage is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with jcoverage; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 *
 */
package com.jcoverage.coverage.reporting.collation;

import com.jcoverage.reporting.AbstractPage;
import com.jcoverage.reporting.Column;
import com.jcoverage.reporting.DefaultLineCategory;
import com.jcoverage.reporting.Line;
import com.jcoverage.reporting.LineCategory;
import com.jcoverage.reporting.Page;
import java.util.ArrayList;
import java.util.List;

/**
 *
 */
public class ReportSummaryPage extends AbstractPage implements Page {
  
  public static DefaultLineCategory CATEGORY_PACKAGE_SUMMARY=new DefaultLineCategory("Package Summary");

  static {
    CATEGORY_PACKAGE_SUMMARY.addColumn(ReportSummaryPackageLine.COLUMN_PACKAGE_NAME);
    CATEGORY_PACKAGE_SUMMARY.addColumn(ReportSummaryPackageLine.COLUMN_TOTAL_JAVAFILES);
    CATEGORY_PACKAGE_SUMMARY.addColumn(ReportSummaryPackageLine.COLUMN_TOTAL_LINES);
    CATEGORY_PACKAGE_SUMMARY.addColumn(ReportSummaryPackageLine.COLUMN_AVERAGE_COVERAGE);
    CATEGORY_PACKAGE_SUMMARY.addColumn(ReportSummaryPackageLine.COLUMN_AVERAGE_COVERAGE_PERCENT);
    CATEGORY_PACKAGE_SUMMARY.addColumn(ReportSummaryPackageLine.COLUMN_BRANCH_AVERAGE_COVERAGE);
    CATEGORY_PACKAGE_SUMMARY.addColumn(ReportSummaryPackageLine.COLUMN_BRANCH_AVERAGE_COVERAGE_PERCENT);
  }

  public ReportSummaryPage() {
    super("Summary");
    addCategory(CATEGORY_PACKAGE_SUMMARY);
    addCategory(PackageSummaryPage.CATEGORY_JAVAFILES);
  }

  public Line instantiateLineForCategory(LineCategory category) {
    if(category.equals(CATEGORY_PACKAGE_SUMMARY)) {
      return new ReportSummaryPackageLine();
    } else {
      return null;
    }
  }

}
