/**
 * www.jcoverage.com
 * Copyright (C)2003 jcoverage ltd.
 *
 * This file is part of jcoverage.
 *
 * jcoverage is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published
 * by the Free Software Foundation; either version 2 of the License,
 * or (at your option) any later version.
 *
 * jcoverage is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with jcoverage; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 *
 */
package com.jcoverage.coverage.reporting.collation;

import com.jcoverage.reporting.AbstractPage;
import com.jcoverage.reporting.Column;
import com.jcoverage.reporting.DefaultLineCategory;
import com.jcoverage.reporting.Line;
import com.jcoverage.reporting.LineCategory;
import com.jcoverage.reporting.Page;
import java.util.ArrayList;
import java.util.List;

/**
 *
 */
public class PackageSummaryPage extends AbstractPage implements Page {
  
  public static DefaultLineCategory CATEGORY_JAVAFILES=new DefaultLineCategory("Java files");

  static {
    CATEGORY_JAVAFILES.addColumn(JavaFileLine.COLUMN_FILE_NAME);
    CATEGORY_JAVAFILES.addColumn(JavaFileLine.COLUMN_PATH);
    CATEGORY_JAVAFILES.addColumn(JavaFileLine.COLUMN_SOURCE_LINES);
    CATEGORY_JAVAFILES.addColumn(JavaFileLine.COLUMN_COVERAGE);
    CATEGORY_JAVAFILES.addColumn(JavaFileLine.COLUMN_COVERAGE_PERCENT);
    CATEGORY_JAVAFILES.addColumn(JavaFileLine.COLUMN_BRANCH_COVERAGE);
    CATEGORY_JAVAFILES.addColumn(JavaFileLine.COLUMN_BRANCH_COVERAGE_PERCENT);
  }

  public PackageSummaryPage() {
    super("Package");
    addCategory(CATEGORY_JAVAFILES);
  }

  public Line instantiateLineForCategory(LineCategory category) {
    if(category.equals(CATEGORY_JAVAFILES)) {
      return new JavaFileLine();
    } else {
      return null;
    }
  }

}
