/**
 * www.jcoverage.com
 * Copyright (C)2003 jcoverage ltd.
 *
 * This file is part of jcoverage.
 *
 * jcoverage is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published
 * by the Free Software Foundation; either version 2 of the License,
 * or (at your option) any later version.
 *
 * jcoverage is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with jcoverage; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 *
 */
package com.jcoverage.coverage.reporting.collation;

import java.util.Iterator;

import com.jcoverage.reporting.AbstractLine;
import com.jcoverage.reporting.Column;
import com.jcoverage.reporting.Line;
import com.jcoverage.reporting.Page;

/**
 *
 */
public class OverallSummaryLine extends AbstractLine implements Line {
  
  public static Column COLUMN_TOTAL_JAVAFILES=new Column("files",Integer.class);
  public static Column COLUMN_TOTAL_LINES=new Column("lines",Integer.class);
  public static Column COLUMN_AVERAGE_COVERAGE=new Column("",Double.class);
  public static Column COLUMN_AVERAGE_COVERAGE_PERCENT=new Column("%line",Integer.class);
  public static Column COLUMN_BRANCH_AVERAGE_COVERAGE=new Column("",Double.class);
  public static Column COLUMN_BRANCH_AVERAGE_COVERAGE_PERCENT=new Column("%branch",Integer.class);
  
  public Page instantiateDetailPage() {
    return new ReportSummaryPage();
  }

  public Object getField(Column column) {

    Object o=super.getField(column);

    if (column.equals(COLUMN_TOTAL_LINES)) {
      return new Integer(getTotalLines());
      
    } else if (column.equals(COLUMN_AVERAGE_COVERAGE)) {
      return new Double(getAverageLineCoverageRate());

    } else if (column.equals(COLUMN_AVERAGE_COVERAGE_PERCENT)) {
      return new Integer(FieldHelper.toPercent(getAverageLineCoverageRate()));

    } else if (column.equals(COLUMN_BRANCH_AVERAGE_COVERAGE)) {
      return new Double(getAverageBranchCoverageRate());

    } else if (column.equals(COLUMN_BRANCH_AVERAGE_COVERAGE_PERCENT)) {
      return new Integer(FieldHelper.toPercent(getAverageBranchCoverageRate()));

    } else if (column.equals(COLUMN_TOTAL_JAVAFILES)) {
      return new Integer(getTotalJavaFiles());

    } else {
      return o;

    }
  }

  double getAverageLineCoverageRate() {
    int totalLines=0;
    int coveredLines=0;
    for (Iterator it=getDetailPage().getLines(ReportSummaryPage.CATEGORY_PACKAGE_SUMMARY).iterator();it.hasNext();) {
      Line line=(Line)it.next();
      int sourceLineCount=((Integer)line.getField(ReportSummaryPackageLine.COLUMN_TOTAL_LINES)).intValue();
      totalLines+=sourceLineCount;
      double rate=((Double)line.getField(ReportSummaryPackageLine.COLUMN_AVERAGE_COVERAGE)).doubleValue();
      coveredLines+=(int)(sourceLineCount*rate);
    }

    if (totalLines==0) {
      return 1d;
    } else {
      return (double)coveredLines/totalLines;
    }
  }
  
  double getAverageBranchCoverageRate() {
    if(getDetailPage().getLines(ReportSummaryPage.CATEGORY_PACKAGE_SUMMARY).size()==0) {
      return 0d;
    }

    double total=0d;

    for (Iterator it=getDetailPage().getLines(ReportSummaryPage.CATEGORY_PACKAGE_SUMMARY).iterator();it.hasNext();) {
      Line line=(Line)it.next();
      total+=((Double)line.getField(ReportSummaryPackageLine.COLUMN_BRANCH_AVERAGE_COVERAGE)).doubleValue();
    }

    return total/getDetailPage().getLines(ReportSummaryPage.CATEGORY_PACKAGE_SUMMARY).size();
  }

  int getTotalLines() {
    int totalLines=0;
    for (Iterator it=getDetailPage().getLines(ReportSummaryPage.CATEGORY_PACKAGE_SUMMARY).iterator();it.hasNext();) {
      Line line=(Line)it.next();
      totalLines+=((Integer)line.getField(ReportSummaryPackageLine.COLUMN_TOTAL_LINES)).intValue();
    }
    return totalLines;
  }

  int getTotalJavaFiles() {
    int totalFiles=0;
    for (Iterator it=getDetailPage().getLines(ReportSummaryPage.CATEGORY_PACKAGE_SUMMARY).iterator();it.hasNext();) {
      Line line=(Line)it.next();
      totalFiles+=((Integer)line.getField(ReportSummaryPackageLine.COLUMN_TOTAL_JAVAFILES)).intValue();
    }
    return totalFiles;
  }

}
