/**
 * www.jcoverage.com
 * Copyright (C)2003 jcoverage ltd.
 *
 * This file is part of jcoverage.
 *
 * jcoverage is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published
 * by the Free Software Foundation; either version 2 of the License,
 * or (at your option) any later version.
 *
 * jcoverage is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with jcoverage; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 *
 */
package com.jcoverage.coverage.reporting.collation;

import java.util.Comparator;

public class Ordering {

  String prefix;
  Comparator comparator;
  String description;

  /**
   * Construct a default ordering
   */
  public Ordering(Comparator comparator,String description) {
    this(null,comparator,description);
  }

  /**
   * Construct a default ordering
   */
  public Ordering(String prefix,Comparator comparator,String description) {
    this.prefix=prefix;
    this.comparator=comparator;
    this.description=description;
  }

  /**
   * @return the report filename prefix to prevent filename clashes, or null if this is the default ordering
   */
  public String getPrefix() {
    return prefix;
  }

  public Comparator getComparator() {
    return comparator;
  }

  public String getDescription() {
    return description;
  }

}
