/**
 * www.jcoverage.com
 * Copyright (C)2003 jcoverage ltd.
 *
 * This file is part of jcoverage.
 *
 * jcoverage is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published
 * by the Free Software Foundation; either version 2 of the License,
 * or (at your option) any later version.
 *
 * jcoverage is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with jcoverage; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 *
 */
package com.jcoverage.coverage.reporting.collation;

import java.io.File;

import com.jcoverage.reporting.AbstractLine;
import com.jcoverage.reporting.Column;
import com.jcoverage.reporting.Line;
import com.jcoverage.reporting.Page;

/**
 *
 */
public class JavaFileLine extends AbstractLine implements Line {
  
  public static Column COLUMN_FILE_NAME=new Column("file",String.class);
  public static Column COLUMN_PATH=new Column("sourcepath",String.class);
  public static Column COLUMN_SOURCE_LINES=new Column("lines",Integer.class);
  public static Column COLUMN_COVERAGE_PERCENT=new Column("%line",Integer.class);
  public static Column COLUMN_COVERAGE=new Column("rate",Double.class);
  public static Column COLUMN_BRANCH_COVERAGE_PERCENT=new Column("%branch",Integer.class);
  public static Column COLUMN_BRANCH_COVERAGE=new Column("rate",Double.class);

  JavaFilePage javaFilePage;

  public Page instantiateDetailPage() {
    javaFilePage=new JavaFilePage();
    return javaFilePage;
  }

  public String getClassName() {
    return (String)getField(COLUMN_FILE_NAME);
  }

  public Object getField(Column column) {

    Object o=super.getField(column);

    if (column.equals(COLUMN_SOURCE_LINES)) {
      return new Integer(getSourceLinesCount());
      
    } else if (column.equals(COLUMN_COVERAGE)) {
      return new Double(javaFilePage.getLineCoverageRate());

    } else if (column.equals(COLUMN_COVERAGE_PERCENT)) {
      return new Integer(FieldHelper.toPercent(javaFilePage.getLineCoverageRate()));

    } else if (column.equals(COLUMN_BRANCH_COVERAGE)) {
      return new Double(javaFilePage.getBranchCoverageRate());

    } else if (column.equals(COLUMN_BRANCH_COVERAGE_PERCENT)) {
      return new Integer(FieldHelper.toPercent(javaFilePage.getBranchCoverageRate()));

    } else {
      return o;

    }
  }

  public File getSourceFile() {
    return new File((String)getField(COLUMN_PATH));
  }

  public int getSourceLinesCount() {
    return javaFilePage.getSourceLinesCount();
  }

}
