/**
 * www.jcoverage.com
 * Copyright (C)2003 jcoverage ltd.
 *
 * This file is part of jcoverage.
 *
 * jcoverage is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published
 * by the Free Software Foundation; either version 2 of the License,
 * or (at your option) any later version.
 *
 * jcoverage is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with jcoverage; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 *
 */
package com.jcoverage.coverage;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.Map;
import java.util.Timer;

public class InstrumentationFactory extends InstrumentationPersistence implements Runnable,HasBeenInstrumented {
    
  static final InstrumentationFactory instrumentationFactory=new InstrumentationFactory();
  
  Timer timer=new Timer(true);

  private InstrumentationFactory() {
    merge(loadInstrumentation());

    if(getInstrumentationInterval()>0) {
      timer.schedule(new SaveInstrumentationTask(this),getInstrumentationInterval(),getInstrumentationInterval());
    }
    
    Runtime.getRuntime().addShutdownHook(new Thread(this));
  }

  int getInstrumentationInterval() {
    return Integer.getInteger("com.jcoverage.instrumentation.interval",0).intValue()*1000;
  }

  public void run() {

    saveInstrumentation();


  }

  public static InstrumentationFactory getInstance() {
    return instrumentationFactory;
  }

  public Instrumentation newInstrumentation(Class cl) {

    return newInstrumentation(cl.getName());
  }

  public Instrumentation newInstrumentation(String className) {

    if(!instrumentation.containsKey(className)) {
      instrumentation.put(className,new InstrumentationImpl());
    }
    return (Instrumentation)instrumentation.get(className);
  }
}
