/*
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 2000-2002 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution, if
 *    any, must include the following acknowlegement:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowlegement may appear in the software itself,
 *    if and wherever such third-party acknowlegements normally appear.
 *
 * 4. The names "Ant" and "Apache Software
 *    Foundation" must not be used to endorse or promote products derived
 *    from this software without prior written permission. For written
 *    permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache"
 *    nor may "Apache" appear in their names without prior written
 *    permission of the Apache Group.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */
package com.jcoverage.ant;

import com.jcoverage.coverage.Version;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.IOException;
import java.io.OutputStream;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Copy;
import org.apache.tools.ant.taskdefs.Java;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;
import org.apache.tools.ant.util.IdentityMapper;
import org.apache.tools.ant.util.SourceFileScanner;

public class InstrumentTask extends CommonMatchingTask {
  Ignore ignoreRegex=null;

  public InstrumentTask() {
    super("com.jcoverage.coverage.Instrument");
  }

  public Ignore createIgnore() {
    ignoreRegex=new Ignore();
    return ignoreRegex;
  }

  void coverage(String[] filenames) {
    if(filenames.length==0) {
      return;
    }
      
    for(int i=0;i<filenames.length;i++) {
      getProject().log("Adding "+filenames[i]+" to list",Project.MSG_VERBOSE);
      getJava().createArg().setValue(filenames[i]);
    }
      
    System.out.println("jcoverage "+Version.VERSION_STRING+" copyright (c)2003 jcoverage ltd. http://jcoverage.com/");
    System.out.println("jcoverage is licensed under the GNU General Public License");
    System.out.println("jcoverage comes with ABSOLUTELY NO WARRANTY");
    System.out.println("instrumenting "+filenames.length+" "+(filenames.length==1?"class":"classes")+(toDir!=null?" to "+toDir:""));
    
    if(getJava().executeJava()!=0) {
      throw new BuildException();
    }
  }

  public void execute() throws BuildException {
    if(toDir!=null) {
      getJava().createArg().setValue("-d");
      getJava().createArg().setValue(toDir.toString());
    }

    if(ignoreRegex!=null) {
      getJava().createArg().setValue("-ignore");
      getJava().createArg().setValue(ignoreRegex.getRegex());
    }


    Set filenames=new HashSet();
    Iterator i=fileSets.iterator();

    while(i.hasNext()) {
      FileSet fileSet=(FileSet)i.next();

      getJava().createArg().setValue("-basedir");
      getJava().createArg().setValue(baseDir(fileSet));

      filenames.addAll(Arrays.asList(getFilenames(fileSet)));
    }

    coverage((String[])filenames.toArray(new String[filenames.size()]));
  }
}
