/**
 * Copyright (C)2004 dGIC Corporation.
 *
 * This file is part of djUnit plugin.
 *
 * djUnit plugin is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published
 * by the Free Software Foundation; either version 2 of the License,
 * or (at your option) any later version.
 *
 * djUnit plugin is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with djUnit plugin; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 *
 */
package jp.co.dgic.testing.common;

import java.io.ByteArrayInputStream;

import org.apache.bcel.Repository;
import org.apache.bcel.classfile.JavaClass;

import com.jcoverage.util.JavaClassHelper;

public abstract class AbstractBcelModifier {

	private String name;
	private AbstractBcelModifier nextModifier;

	public AbstractBcelModifier(String name) {
		this.name = name;
	}

	public AbstractBcelModifier setNext(AbstractBcelModifier nextModifier) {
		this.nextModifier = nextModifier;
		return nextModifier;
	}

	public String getName() {
		return name;
	}

	public byte[] getModifiedByteCode(JavaClass jc) throws Exception {

		byte[] modifiedByteCode = modify(jc);

		if (modifiedByteCode != null) {
			Repository.removeClass(jc);
			jc = JavaClassHelper.newJavaClass(new ByteArrayInputStream(modifiedByteCode), jc.getClassName());
			Repository.addClass(jc);
		}

		if (nextModifier == null) {
			return jc.getBytes();
		}

		return nextModifier.getModifiedByteCode(jc);
	}

	protected abstract byte[] modify(JavaClass jc) throws Exception;
}
