/**
 * Copyright (C)2004 dGIC Corporation.
 *
 * This file is part of djUnit plugin.
 *
 * djUnit plugin is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published
 * by the Free Software Foundation; either version 2 of the License,
 * or (at your option) any later version.
 *
 * djUnit plugin is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with djUnit plugin; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 *
 */
package com.jcoverage.coverage.asm;

import org.objectweb.asm.ClassAdapter;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;

import com.jcoverage.coverage.InstrumentData;

public class AsmClassInstrumenter extends ClassAdapter {

	private InstrumentData instrumentData;
	private String className;

	public String getClassName() {
		return this.className;
	}

	public AsmClassInstrumenter(ClassVisitor cv) {
		super(cv);
	}

	public InstrumentData getInstrumentData() {
		return instrumentData;
	}

	public void visit(int version, int access, String name, String signature,
			String superName, String[] interfaces) {

		this.className = name.replace('/', '.');
		this.instrumentData = new InstrumentData(className);

		super.visit(version, access, name, signature, superName, interfaces);
	}

	public void visitSource(String source, String debug) {
		super.visitSource(source, debug);
		instrumentData.setSourceFileName(source);
	}

	public MethodVisitor visitMethod(int access,  String name,
			String desc, String signature, String[] exceptions) {

		MethodVisitor mv = cv.visitMethod(access, name, desc, signature, exceptions);
		instrumentData.addMethodNamesAndSignatures(name, desc);

		return new AsmMethodInstrumenter(mv, className, name, desc, instrumentData);
	}

}
